/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.io.Retryable;
import org.arp.javautil.io.Retryer;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.DataSourceReadException;
import org.protempa.backend.dsb.relationaldb.RetryableSQLExecutor;
import org.protempa.backend.dsb.relationaldb.SQLExecutor;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;

final class RetryingSQLExecutor
extends SQLExecutor {
    private int retryCount;

    RetryingSQLExecutor(ConnectionSpec connectionSpec, String backendNameForMessages, Integer timeout, int retryCount) {
        super(connectionSpec, backendNameForMessages, timeout);
        assert (retryCount >= 0) : "retryCount must be >= 0";
        this.retryCount = retryCount;
    }

    @Override
    void executeSelect(String entitySpecName, String query, SQLGenResultProcessor resultProcessor) throws DataSourceReadException {
        Logger logger = SQLGenUtil.logger();
        if (Boolean.getBoolean("protempa.dsb.relationaldatabase.skipexecution")) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Data source backend {0} is skipping query for {1}", new Object[]{this.getBackendNameForMessages(), entitySpecName});
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Data source backend {0} is executing query for {1}", new Object[]{this.getBackendNameForMessages(), entitySpecName});
            }
            this.logQueryTimeout(logger);
            RetryableSQLExecutor operation = new RetryableSQLExecutor(this.getConnectionSpec(), query, resultProcessor, this.getTimeout());
            Retryer retryer = new Retryer(this.retryCount);
            if (!retryer.execute((Retryable)operation)) {
                SQLException ex = org.arp.javautil.sql.SQLExecutor.assembleSQLException((List)retryer.getErrors());
                throw new DataSourceReadException("Error retrieving " + entitySpecName + " from data source backend " + this.getBackendNameForMessages(), (Throwable)ex);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Query for {0} in data source backend {1} is complete", new Object[]{entitySpecName, this.getBackendNameForMessages()});
            }
        }
    }
}

