/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Serializable;
import org.drools.base.accumulators.AccumulateFunction;

public class MaxAccumulateFunction
implements AccumulateFunction {
    private static final long serialVersionUID = -6110228336507748202L;

    public Object createContext() {
        return new MaxData();
    }

    public void init(Object context) throws Exception {
        MaxData data = (MaxData)context;
        data.max = Double.MIN_VALUE;
    }

    public void accumulate(Object context, Object value) {
        MaxData data = (MaxData)context;
        data.max = Math.max(data.max, ((Number)value).doubleValue());
    }

    public void reverse(Object context, Object value) throws Exception {
    }

    public Object getResult(Object context) throws Exception {
        MaxData data = (MaxData)context;
        return new Double(data.max);
    }

    public boolean supportsReverse() {
        return false;
    }

    protected static class MaxData
    implements Serializable {
        private static final long serialVersionUID = -7020207404432163956L;
        public double max = Double.MIN_VALUE;

        protected MaxData() {
        }
    }
}

