/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatStat
extends Stat<Float> {
    private static final long serialVersionUID = 1L;
    private float val;

    public FloatStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    public FloatStat(StatGroup group, StatDefinition definition, float val) {
        super(group, definition);
        this.val = val;
    }

    @Override
    public Float get() {
        return Float.valueOf(this.val);
    }

    @Override
    public void set(Float newValue) {
        this.val = newValue.floatValue();
    }

    @Override
    public void add(Stat<Float> otherStat) {
        this.val += otherStat.get().floatValue();
    }

    @Override
    public Stat<Float> computeInterval(Stat<Float> base) {
        Stat<Float> ret = this.copy();
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            ret.set(Float.valueOf(this.get().floatValue() - base.get().floatValue()));
        }
        return ret;
    }

    @Override
    public void negate() {
        this.val = -this.val;
    }

    @Override
    public void clear() {
        this.val = 0.0f;
    }

    @Override
    protected String getFormattedValue() {
        return Float.toString(this.val);
    }

    @Override
    public boolean isNotSet() {
        return this.val == 0.0f;
    }
}

