/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.datastore;

import java.io.File;
import java.io.IOException;
import org.arp.javautil.io.FileUtil;
import org.eurekaclinical.datastore.BdbCacheFactory;
import org.eurekaclinical.datastore.BdbUtil;
import org.eurekaclinical.datastore.DataStore;
import org.protempa.datastore.DataStoreCreator;

public abstract class AbstractDataStoreCreator<K, V>
implements DataStoreCreator<K, V> {
    private final String environmentName;

    protected AbstractDataStoreCreator() {
        this(null);
    }

    protected AbstractDataStoreCreator(String environmentName) {
        this.environmentName = environmentName;
    }

    protected String getEnvironmentName() {
        return this.environmentName;
    }

    protected abstract String nextDatabaseName();

    @Override
    public DataStore<K, V> newCacheStore() throws IOException {
        String tempEnvironment = this.environmentName == null ? BdbUtil.uniqueEnvironment((String)"cache-store", null, (File)FileUtil.getTempDirectory()) : this.environmentName;
        BdbCacheFactory bdbCacheFactory = new BdbCacheFactory(tempEnvironment, true);
        return bdbCacheFactory.newInstance(this.nextDatabaseName());
    }
}

