/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.interval;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.protempa.graph.Weight;
import org.protempa.proposition.interval.ConstraintNetwork;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Unit;

public final class DefaultInterval
extends Interval {
    private ConstraintNetwork cn;
    private boolean constraintNetworkStale = true;
    private boolean simple;

    DefaultInterval(Long minStart, Long maxStart, Granularity startGranularity, Long minFinish, Long maxFinish, Granularity finishGranularity, Long minLength, Long maxLength, Unit lengthUnit) {
        super(minStart, maxStart, startGranularity, minFinish, maxFinish, finishGranularity, minLength, maxLength, lengthUnit);
    }

    DefaultInterval(Long start, Granularity startGranularity, Long finish, Granularity finishGranularity, Long length, Unit lengthUnit) {
        super(start, startGranularity, finish, finishGranularity, length, lengthUnit);
    }

    DefaultInterval(Long start, Granularity startGranularity, Long finish, Granularity finishGranularity) {
        super(start, startGranularity, finish, finishGranularity, null, null);
    }

    DefaultInterval(Long start, Granularity startGranularity) {
        super(start, startGranularity, null, null, null, null);
    }

    DefaultInterval() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculator() {
        DefaultInterval defaultInterval = this;
        synchronized (defaultInterval) {
            if (this.constraintNetworkStale) {
                this.computeLength();
                if (this.cn == null) {
                    this.cn = new ConstraintNetwork(1);
                    if (this.v[0] == null || this.v[1] == null || this.v[2] == null || this.v[3] == null || this.v[4] != null || this.v[5] != null || this.v[2].compareTo(this.v[1]) <= 0) {
                        this.cn.addInterval(this);
                    } else {
                        this.simple = true;
                    }
                } else {
                    this.cn.clear();
                    if (this.v[0] == null || this.v[1] == null || this.v[2] == null || this.v[3] == null || this.v[2].compareTo(this.v[1]) <= 0) {
                        this.cn.addInterval(this);
                    } else {
                        this.simple = true;
                    }
                }
                this.constraintNetworkStale = false;
            }
        }
    }

    public boolean isValid() {
        this.calculator();
        return this.cn.getConsistent();
    }

    @Override
    public Long getMinimumStart() {
        this.calculator();
        if (this.simple) {
            return this.v[0];
        }
        Weight minStart = this.cn.getMinimumStart();
        return minStart.isInfinity() ? null : Long.valueOf(minStart.value());
    }

    @Override
    public Long getMaximumStart() {
        this.calculator();
        if (this.simple) {
            return this.v[1];
        }
        Weight maxStart = this.cn.getMaximumStart();
        return maxStart.isInfinity() ? null : Long.valueOf(maxStart.value());
    }

    @Override
    public Long getMinimumFinish() {
        this.calculator();
        if (this.simple) {
            return this.v[2];
        }
        Weight minFinish = this.cn.getMinimumFinish();
        return minFinish.isInfinity() ? null : Long.valueOf(minFinish.value());
    }

    @Override
    public Long getMaximumFinish() {
        this.calculator();
        if (this.simple) {
            return this.v[3];
        }
        Weight maxFinish = this.cn.getMaximumFinish();
        return maxFinish.isInfinity() ? null : Long.valueOf(maxFinish.value());
    }

    @Override
    public Long getMinimumLength() {
        this.calculator();
        if (this.simple) {
            return this.v[2] - this.v[1];
        }
        Weight minDur = this.cn.getMinimumDuration();
        return minDur.isInfinity() ? null : Long.valueOf(minDur.value());
    }

    @Override
    public Long getMaximumLength() {
        this.calculator();
        if (this.simple) {
            return this.v[3] - this.v[0];
        }
        Weight maxDur = this.cn.getMaximumDuration();
        return maxDur.isInfinity() ? null : Long.valueOf(maxDur.value());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.constraintNetworkStale = true;
    }
}

