/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.protempa.KnowledgeSource;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.xml.AbstractConverter;

class InequalityValueObjectConverter
extends AbstractConverter {
    InequalityValueObjectConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class clazz) {
        return clazz == InequalityNumberValue.class;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        InequalityNumberValue ival = (InequalityNumberValue)value;
        writer.setValue(ival.getComparator().getComparatorString() + ival.getBigDecimal().toPlainString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String value = reader.getValue();
        InequalityNumberValue ival = InequalityNumberValue.parse(value);
        return ival;
    }
}

