/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.valueset;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.Attribute;
import org.protempa.AttributeBuilder;
import org.protempa.ProtempaUtil;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueBuilder;
import org.protempa.valueset.ValueSetElement;

public class ValueSetElementBuilder {
    private static final AttributeBuilder[] EMPTY_ATTR_BUILDER_ARR = new AttributeBuilder[0];
    private ValueBuilder valueBuilder;
    private String displayName;
    private String abbrevDisplayName;
    private AttributeBuilder[] attributeBuilders = EMPTY_ATTR_BUILDER_ARR;

    public ValueBuilder getValueBuilder() {
        return this.valueBuilder;
    }

    public void setValueBuilder(ValueBuilder value) {
        this.valueBuilder = value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getAbbrevDisplayName() {
        return this.abbrevDisplayName;
    }

    public void setAbbrevDisplayName(String abbrevDisplayName) {
        this.abbrevDisplayName = abbrevDisplayName;
    }

    public AttributeBuilder[] getAttributeBuilders() {
        return (AttributeBuilder[])this.attributeBuilders.clone();
    }

    public void setAttributeBuilders(AttributeBuilder[] attributeBuilders) {
        if (attributeBuilders != null) {
            ProtempaUtil.checkArrayForNullElement(attributeBuilders, "attributeBuilders");
            this.attributeBuilders = (AttributeBuilder[])attributeBuilders.clone();
        } else {
            this.attributeBuilders = EMPTY_ATTR_BUILDER_ARR;
        }
    }

    public ValueSetElement build() {
        Attribute[] attributes = new Attribute[this.attributeBuilders.length];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = this.attributeBuilders[i].build();
        }
        return new ValueSetElement(this.valueBuilder != null ? (Value)this.valueBuilder.build() : null, this.displayName, this.abbrevDisplayName, attributes);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.valueBuilder);
        hash = 61 * hash + Objects.hashCode(this.displayName);
        hash = 61 * hash + Objects.hashCode(this.abbrevDisplayName);
        hash = 61 * hash + Arrays.deepHashCode(this.attributeBuilders);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSetElementBuilder other = (ValueSetElementBuilder)obj;
        if (!Objects.equals(this.valueBuilder, other.valueBuilder)) {
            return false;
        }
        if (!Objects.equals(this.displayName, other.displayName)) {
            return false;
        }
        if (!Objects.equals(this.abbrevDisplayName, other.abbrevDisplayName)) {
            return false;
        }
        return Arrays.deepEquals(this.attributeBuilders, other.attributeBuilders);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

