/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.AtLeastNColumnSpec;
import org.protempa.dest.table.Link;
import org.protempa.xml.AbstractConverter;

class AtLeastNColumnSpecConverter
extends AbstractConverter {
    private static final String FALSE_OUTPUT = "falseOutput";
    private static final String TRUE_OUTPUT = "trueOutput";
    private static final String COLUMN_NAME_OVERRIDE = "columnNameOverride";
    private static final String LINKS = "links";
    private static final String N = "n";

    AtLeastNColumnSpecConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return AtLeastNColumnSpec.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        AtLeastNColumnSpec columnSpec = (AtLeastNColumnSpec)source;
        String columnNameOverride = columnSpec.getColumnNameOverride();
        if (columnNameOverride != null) {
            writer.addAttribute(COLUMN_NAME_OVERRIDE, columnNameOverride);
        }
        writer.addAttribute(N, Integer.toString(columnSpec.getN()));
        writer.addAttribute(TRUE_OUTPUT, columnSpec.getTrueOutput());
        writer.addAttribute(FALSE_OUTPUT, columnSpec.getFalseOutput());
        writer.startNode(LINKS);
        context.convertAnother((Object)columnSpec.getLinks());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String falseOutput;
        String columnNameOverride = reader.getAttribute(COLUMN_NAME_OVERRIDE);
        int n = this.intAttributeValue(reader, N);
        String trueOutput = reader.getAttribute(TRUE_OUTPUT);
        if (trueOutput == null) {
            trueOutput = "true";
        }
        if ((falseOutput = reader.getAttribute(FALSE_OUTPUT)) == null) {
            falseOutput = "false";
        }
        reader.moveDown();
        this.expect(reader, LINKS);
        Link[] links = (Link[])context.convertAnother(null, Link[].class);
        reader.moveUp();
        this.expectNoMore(reader);
        return new AtLeastNColumnSpec(columnNameOverride, n, links, trueOutput, falseOutput);
    }
}

