/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Comparator;
import org.mvel.ConversionException;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.Derivation;
import org.protempa.dest.table.PropertyConstraint;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.value.Value;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.AllowedValuesConverter;
import org.protempa.xml.BehaviorValueConverter;
import org.protempa.xml.PropIDsConverter;
import org.protempa.xml.PropertyConstraintsConverter;
import org.protempa.xml.PropositionComparatorValueConverter;
import org.protempa.xml.RelationConverter;

class DerivationConverter
extends AbstractConverter {
    private static final String RELATION = "relation";
    private static final String ALLOWED_VALUES = "allowedValues";
    private static final String PROPERTY_CONSTRAINTS = "propertyConstraints";
    private static final String PROPOSITION_IDS = "propositionIDs";
    private static final String PROPOSITION_COMPARATOR = "propositionComparator";
    private static final String TO_INDEX = "toIndex";
    private static final String FROM_INDEX = "fromIndex";
    private static final String BEHAVIOR = "behavior";

    DerivationConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return Derivation.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Relation relation;
        Value[] allowedValues;
        Derivation derivation = (Derivation)source;
        BehaviorValueConverter behaviorConverter = new BehaviorValueConverter();
        String behaviorString = behaviorConverter.toString((Object)derivation.getBehavior());
        writer.addAttribute(BEHAVIOR, behaviorString);
        writer.addAttribute(FROM_INDEX, Integer.toString(derivation.getFromIndex()));
        writer.addAttribute(TO_INDEX, Integer.toString(derivation.getToIndex()));
        Comparator<Proposition> comparator = derivation.getComparator();
        if (comparator != null) {
            PropositionComparatorValueConverter converter = new PropositionComparatorValueConverter();
            writer.addAttribute(PROPOSITION_COMPARATOR, converter.toString(comparator));
        }
        writer.startNode(PROPOSITION_IDS);
        context.convertAnother((Object)derivation.getPropositionIds(), (Converter)new PropIDsConverter(this.getKnowledgeSource()));
        writer.endNode();
        PropertyConstraint[] constraints = derivation.getConstraints();
        if (constraints != null && constraints.length > 0) {
            writer.startNode(PROPERTY_CONSTRAINTS);
            PropertyConstraintsConverter converter = new PropertyConstraintsConverter(this.getKnowledgeSource());
            context.convertAnother((Object)constraints, (Converter)converter);
            writer.endNode();
        }
        if ((allowedValues = derivation.getAllowedValues()) != null && allowedValues.length > 0) {
            writer.startNode(ALLOWED_VALUES);
            AllowedValuesConverter converter = new AllowedValuesConverter(this.getKnowledgeSource());
            context.convertAnother((Object)allowedValues, (Converter)converter);
            writer.endNode();
        }
        if ((relation = derivation.getRelation()) != null) {
            writer.startNode(RELATION);
            RelationConverter relationConverter = new RelationConverter(this.getKnowledgeSource());
            context.convertAnother((Object)relation, (Converter)relationConverter);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String behaviorString = this.requiredAttributeValue(reader, BEHAVIOR);
        BehaviorValueConverter behaviorConverter = new BehaviorValueConverter();
        Derivation.Behavior behavior = (Derivation.Behavior)((Object)behaviorConverter.fromString(behaviorString));
        int fromIndex = this.intAttributeValue(reader, FROM_INDEX, -1);
        int toIndex = this.intAttributeValue(reader, TO_INDEX, -1);
        String comparatorString = reader.getAttribute(PROPOSITION_COMPARATOR);
        Comparator<Proposition> comparator = comparatorString != null ? this.convertComparatorString(comparatorString) : null;
        this.expectChildren(reader);
        reader.moveDown();
        this.expect(reader, PROPOSITION_IDS);
        String[] propositionIds = (String[])context.convertAnother(null, String[].class, (Converter)new PropIDsConverter(this.getKnowledgeSource()));
        reader.moveUp();
        PropertyConstraint[] constraints = null;
        Value[] allowedValues = null;
        Relation relation = null;
        while (reader.hasMoreChildren()) {
            AbstractConverter converter;
            reader.moveDown();
            if (PROPERTY_CONSTRAINTS.equals(reader.getNodeName())) {
                if (constraints != null) {
                    throw new ConversionException("diversion contains multiple propertyConstraints elements");
                }
                converter = new PropertyConstraintsConverter(this.getKnowledgeSource());
                constraints = (PropertyConstraint[])context.convertAnother(null, PropertyConstraint[].class, (Converter)converter);
                reader.moveUp();
                continue;
            }
            if (ALLOWED_VALUES.equals(reader.getNodeName())) {
                if (allowedValues != null) {
                    throw new ConversionException("diversion contains multiple allowedValues elements");
                }
                converter = new AllowedValuesConverter(this.getKnowledgeSource());
                allowedValues = (Value[])context.convertAnother(null, Value[].class, (Converter)converter);
                reader.moveUp();
                continue;
            }
            if (RELATION.equals(reader.getNodeName())) {
                if (relation != null) {
                    throw new ConversionException("diversion contains multiple relation elements");
                }
                RelationConverter relationConverter = new RelationConverter(this.getKnowledgeSource());
                relation = (Relation)context.convertAnother(null, Relation.class, (Converter)relationConverter);
                reader.moveUp();
                continue;
            }
            throw new ConversionException("Encountered unexpected element: " + reader.getNodeName());
        }
        return new Derivation(propositionIds, constraints, comparator, fromIndex, toIndex, allowedValues, behavior, relation);
    }

    private Comparator<Proposition> convertComparatorString(String comparatorString) {
        PropositionComparatorValueConverter converter = new PropositionComparatorValueConverter();
        return (Comparator)converter.fromString(comparatorString);
    }
}

