/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.eurekaclinical.datastore.DataStore;
import org.protempa.AbstractExecutionStrategy;
import org.protempa.AlgorithmSource;
import org.protempa.ProtempaUtil;
import org.protempa.proposition.Proposition;

class StatefulExecutionStrategy
extends AbstractExecutionStrategy {
    @Override
    public void initialize() {
    }

    StatefulExecutionStrategy(AlgorithmSource algorithmSource) {
        super(algorithmSource);
    }

    private StatefulSession applyRules(String keyId, List<?> objects) {
        StatefulSession workingMemory = this.ruleBase.newStatefulSession(false);
        workingMemory.setGlobal("keyId", (Object)keyId);
        ProtempaUtil.logger().log(Level.FINEST, "Adding {0} objects for key ID {1}", new Object[]{objects.size(), keyId});
        for (Object obj : objects) {
            workingMemory.insert(obj);
        }
        workingMemory.fireAllRules();
        int wmCount = 0;
        Iterator itr = workingMemory.iterateObjects();
        while (itr.hasNext()) {
            ++wmCount;
            itr.next();
        }
        ProtempaUtil.logger().log(Level.FINEST, "Iterated over {0} objects", new Object[]{wmCount});
        return workingMemory;
    }

    @Override
    public Iterator<Proposition> execute(String keyId, Set<String> propositionIds, List<?> objects, DataStore<String, WorkingMemory> wmStore) {
        StatefulSession workingMemory = this.applyRules(keyId, objects);
        ProtempaUtil.logger().log(Level.FINEST, "Persisting working memory for key ID {0}", keyId);
        wmStore.put((Object)keyId, (Object)workingMemory);
        workingMemory.dispose();
        ProtempaUtil.logger().log(Level.FINEST, "Persisted working memory for key ID {0}", keyId);
        return null;
    }

    @Override
    public void cleanup() {
    }
}

