/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.valueset;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.Attribute;
import org.protempa.AttributeBuilder;
import org.protempa.ProtempaUtil;
import org.protempa.proposition.value.Value;
import org.protempa.valueset.ValueSetElementBuilder;

public final class ValueSetElement {
    private static final Attribute[] EMPTY_ATTRIBUTE_ARR = new Attribute[0];
    private final Value value;
    private final String displayName;
    private final String abbrevDisplayName;
    private final Attribute[] attributes;

    public ValueSetElement(Value value) {
        this(value, null, null);
    }

    public ValueSetElement(Value value, String displayName) {
        this(value, displayName, null);
    }

    public ValueSetElement(Value value, String displayName, String abbrevDisplayName) {
        this(value, displayName, abbrevDisplayName, null);
    }

    public ValueSetElement(Value value, String displayName, String abbrevDisplayName, Attribute[] attributes) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        displayName = displayName == null ? "" : displayName.intern();
        abbrevDisplayName = abbrevDisplayName == null ? "" : abbrevDisplayName.intern();
        this.value = value;
        this.displayName = displayName;
        this.abbrevDisplayName = abbrevDisplayName;
        if (attributes != null) {
            ProtempaUtil.checkArrayForNullElement(attributes, "attributes");
            this.attributes = (Attribute[])attributes.clone();
        } else {
            this.attributes = EMPTY_ATTRIBUTE_ARR;
        }
    }

    public String getAbbrevDisplayName() {
        return this.abbrevDisplayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Value getValue() {
        return this.value;
    }

    public Attribute[] getAttributes() {
        return (Attribute[])this.attributes.clone();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public ValueSetElementBuilder asBuilder() {
        ValueSetElementBuilder builder = new ValueSetElementBuilder();
        builder.setAbbrevDisplayName(this.abbrevDisplayName);
        builder.setDisplayName(this.displayName);
        builder.setValueBuilder(this.value.asBuilder());
        AttributeBuilder[] builders = new AttributeBuilder[this.attributes.length];
        for (int i = 0; i < builders.length; ++i) {
            builders[i] = this.attributes[i].asBuilder();
        }
        builder.setAttributeBuilders(builders);
        return builder;
    }
}

