/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ModifierConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropertyConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.table.AbstractFactHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.InvalidFactException;
import edu.emory.cci.aiw.i2b2etl.dest.table.ObservationFact;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.ProviderDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.RejectedFactHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.RejectedFactHandlerFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import edu.emory.cci.aiw.i2b2etl.dest.table.ValueFlagCode;
import edu.emory.cci.aiw.i2b2etl.dest.table.VisitDimension;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.Value;

public abstract class FactHandler
extends AbstractFactHandler {
    public static final String TEMP_OBSERVATION_TABLE = "ek_temp_observation";
    public static final String TEMP_OBSERVATION_COMPLETE_TABLE = "ek_temp_observation_complete";
    private final String startConfig;
    private final String finishConfig;
    private final String unitsPropertyName;
    private final String propertyName;
    private final Metadata metadata;
    private final RejectedFactHandler rejectedFactHandler;

    public FactHandler(ConnectionSpec connSpec, String propertyName, String startConfig, String finishConfig, String unitsPropertyName, Metadata metadata, RejectedFactHandlerFactory rejectedFactHandlerFactory) throws SQLException {
        super(connSpec, "insert into ek_temp_observation(encounter_id, encounter_id_source, concept_cd, patient_id, patient_id_source, provider_id, start_date, modifier_cd, instance_num, valtype_cd, tval_char, nval_num, valueflag_cd, quantity_num, confidence_num, observation_blob, units_cd, end_date, location_cd, update_date, download_date, import_date, sourcesystem_cd, upload_id, delete_date) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null");
        }
        this.propertyName = propertyName;
        this.startConfig = startConfig;
        this.finishConfig = finishConfig;
        this.unitsPropertyName = unitsPropertyName;
        this.metadata = metadata;
        this.rejectedFactHandler = rejectedFactHandlerFactory != null ? rejectedFactHandlerFactory.getInstance() : null;
    }

    Metadata getMetadata() {
        return this.metadata;
    }

    public String getStartConfig() {
        return this.startConfig;
    }

    public String getFinishConfig() {
        return this.finishConfig;
    }

    public String getUnitsPropertyName() {
        return this.unitsPropertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            if (this.rejectedFactHandler != null) {
                this.rejectedFactHandler.close();
            }
        }
    }

    public abstract void handleRecord(PatientDimension var1, VisitDimension var2, ProviderDimension var3, Proposition var4, Map<Proposition, List<Proposition>> var5, Map<Proposition, List<Proposition>> var6, Map<UniqueId, Proposition> var7, Set<Proposition> var8) throws InvalidFactException;

    protected ObservationFact populateObxFact(Proposition prop, Proposition encounterProp, PatientDimension patient, VisitDimension visit, ProviderDimension provider, PropertyConceptId conceptId, ModifierConceptId modConceptId) throws InvalidFactException {
        Concept modConcept;
        Concept concept = this.metadata.getFromIdCache(conceptId);
        assert (concept != null) : "No concept found matching concept id " + conceptId;
        if (modConceptId != null) {
            modConcept = this.metadata.getFromIdCache(modConceptId);
            assert (modConcept != null) : "No modifier concept found matching concept id " + modConceptId;
        } else {
            modConcept = null;
        }
        Date start = this.handleStartDate(prop, encounterProp, null);
        Date finish = this.handleFinishDate(prop, encounterProp, null);
        Value value = modConcept != null ? this.handleValue(prop, modConcept, modConceptId) : this.handleValue(prop, concept, conceptId);
        ValueFlagCode valueFlagCode = ValueFlagCode.NO_VALUE_FLAG;
        String units = this.handleUnits(prop);
        ObservationFact obx = new ObservationFact();
        obx.reset();
        obx.setStartDate(TableUtil.setTimestampAttribute(start));
        if (start == null) {
            obx.setRejected(true);
            obx.addRejectionReason("Null start date");
        }
        obx.setEndDate(TableUtil.setTimestampAttribute(finish));
        obx.setPatient(patient);
        obx.setVisit(visit);
        obx.setProvider(provider);
        obx.setConcept(concept);
        obx.setValue(value);
        obx.setValueFlagCode(valueFlagCode);
        obx.setUnits(units);
        obx.setSourceSystem(prop.getSourceSystem().getStringRepresentation());
        obx.setDownloadDate(TableUtil.setTimestampAttribute(prop.getDownloadDate()));
        Date updateDate = prop.getUpdateDate();
        if (updateDate == null) {
            updateDate = prop.getCreateDate();
        }
        obx.setUpdateDate(TableUtil.setTimestampAttribute(updateDate));
        obx.setInstanceNum(prop.getUniqueId().getLocalUniqueId().getNumericalId());
        if (concept != null) {
            obx.setDisplayName(concept.getDisplayName());
            if (modConcept != null) {
                obx.setModifierCd(modConcept.getConceptCode());
            }
            if (!obx.isRejected()) {
                concept.setInUse(true);
                if (modConcept != null) {
                    modConcept.setInUse(true);
                }
            }
        }
        return obx;
    }

    @Override
    public void insert(ObservationFact record) throws SQLException {
        if (record != null) {
            if (record.isRejected()) {
                if (this.rejectedFactHandler != null) {
                    this.rejectedFactHandler.insert(record);
                }
            } else {
                super.insert(record);
            }
        }
    }

    protected final String handleUnits(Proposition prop) {
        Value unitsVal;
        String value = this.unitsPropertyName != null && prop != null ? ((unitsVal = prop.getProperty(this.unitsPropertyName)) != null ? unitsVal.getFormatted() : null) : null;
        return value;
    }

    private Value handleValue(Proposition prop, Concept concept, PropertyConceptId conceptId) {
        Object value = null;
        if (prop != null && concept != null && conceptId != null) {
            if (this.propertyName != null) {
                Value tvalCharVal = prop.getProperty(this.propertyName);
                if (tvalCharVal != null) {
                    value = tvalCharVal;
                }
            } else {
                value = concept.isModifier() ? prop.getProperty(conceptId.getPropertyName()) : (prop instanceof Parameter ? ((Parameter)prop).getValue() : NominalValue.getInstance((String)prop.getId()));
            }
        }
        return value;
    }

    protected final Date handleStartDate(Proposition prop, Proposition encounterProp, Value propertyVal) throws InvalidFactException {
        Date start;
        if (prop instanceof TemporalProposition) {
            start = AbsoluteTimeGranularityUtil.asDate((Long)((TemporalProposition)prop).getInterval().getMinStart());
        } else if (this.startConfig != null) {
            switch (this.startConfig) {
                case "start": {
                    start = AbsoluteTimeGranularityUtil.asDate((Long)((TemporalProposition)encounterProp).getInterval().getMinStart());
                    break;
                }
                case "finish": {
                    start = AbsoluteTimeGranularityUtil.asDate((Long)((TemporalProposition)encounterProp).getInterval().getMinFinish());
                    break;
                }
                default: {
                    start = null;
                    break;
                }
            }
        } else {
            start = null;
        }
        return start;
    }

    protected final Date handleFinishDate(Proposition prop, Proposition encounterProp, Value propertyVal) throws InvalidFactException {
        Date start;
        if (prop instanceof TemporalProposition) {
            start = AbsoluteTimeGranularityUtil.asDate((Long)((TemporalProposition)prop).getInterval().getMinFinish());
        } else if (this.finishConfig != null) {
            switch (this.finishConfig) {
                case "start": {
                    start = AbsoluteTimeGranularityUtil.asDate((Long)((TemporalProposition)encounterProp).getInterval().getMinStart());
                    break;
                }
                case "finish": {
                    start = AbsoluteTimeGranularityUtil.asDate((Long)((TemporalProposition)encounterProp).getInterval().getMinFinish());
                    break;
                }
                default: {
                    start = null;
                    break;
                }
            }
        } else {
            start = null;
        }
        return start;
    }
}

