/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import java.io.IOException;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;

final class ValueSetSupport {
    private static final char DELIMITER = '^';
    private static final CSVFormat CSV_FORMAT = CSVFormat.newFormat((char)'^').withQuote('\"').withQuoteMode(QuoteMode.ALL).withEscape('\\');
    private String declaringPropId;
    private String propertyName;

    ValueSetSupport() {
    }

    boolean isValid() {
        return this.declaringPropId != null && this.propertyName != null;
    }

    String getDeclaringPropId() {
        return this.declaringPropId;
    }

    void setDeclaringPropId(String declaringPropId) {
        this.declaringPropId = declaringPropId;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    void parseId(String id) {
        try (CSVParser csvParser = CSVParser.parse((String)id, (CSVFormat)CSV_FORMAT);){
            List records = csvParser.getRecords();
            if (records.size() != 1) {
                return;
            }
            CSVRecord record = (CSVRecord)records.get(0);
            if (record.size() != 2) {
                return;
            }
            this.declaringPropId = record.get(0);
            this.propertyName = record.get(1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getId() {
        if (this.declaringPropId == null) {
            throw new IllegalStateException("declaringPropId cannot be null");
        }
        if (this.propertyName == null) {
            throw new IllegalStateException("propertyName cannot be null");
        }
        return CSV_FORMAT.format(new Object[]{this.declaringPropId, this.propertyName});
    }
}

