/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import org.mvel.ASTLinkedList;
import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.CompiledExpression;
import org.mvel.ParserContext;
import org.mvel.PropertyVerifier;
import org.mvel.ast.Assignment;
import org.mvel.ast.LiteralNode;
import org.mvel.ast.Substatement;
import org.mvel.util.CompilerTools;
import org.mvel.util.ExecutionStack;

public class ExpressionCompiler
extends AbstractParser {
    private Class returnType;
    private boolean verifying = true;
    private boolean secondPassOptimization = false;
    private ParserContext pCtx;

    public CompiledExpression compile() {
        return this.compile(new ParserContext());
    }

    public CompiledExpression compile(ParserContext ctx) {
        if (this.debugSymbols) {
            ctx.setDebugSymbols(this.debugSymbols);
        } else if (ctx.isDebugSymbols()) {
            this.debugSymbols = true;
        }
        try {
            this.newContext(ctx);
            CompiledExpression compiledExpression = this._compile();
            return compiledExpression;
        }
        finally {
            this.removeContext();
            if (this.pCtx.isFatalError()) {
                ExpressionCompiler.contextControl(1, null, null);
                throw new CompileException("Failed to compile: " + this.pCtx.getErrorList().size() + " compilation error(s)", this.pCtx.getErrorList());
            }
        }
    }

    public CompiledExpression _compile() {
        ASTLinkedList astLinkedList = new ASTLinkedList();
        this.stk = new ExecutionStack();
        this.dStack = new ExecutionStack();
        this.pCtx = this.getParserContext();
        this.debugSymbols = this.pCtx.isDebugSymbols();
        try {
            ASTNode tk;
            if (this.verifying) {
                this.pCtx.initializeTables();
            }
            this.fields |= 0x10;
            while ((tk = this.nextToken()) != null) {
                if (tk.fields == -1) {
                    astLinkedList.addTokenNode(tk);
                    continue;
                }
                this.returnType = tk.getEgressType();
                if (tk instanceof Substatement) {
                    ExpressionCompiler subCompiler = new ExpressionCompiler(tk.getNameAsArray(), this.pCtx);
                    tk.setAccessor(subCompiler._compile());
                    if (subCompiler.isLiteralOnly()) {
                        tk = new LiteralNode(tk.getReducedValueAccelerated(null, null, null));
                    }
                    this.returnType = subCompiler.getReturnType();
                }
                if (tk.isLiteral() && tk.getLiteralValue() != LITERALS.get("this")) {
                    this.literalOnly = true;
                    ASTNode tkOp = this.nextTokenSkipSymbols();
                    if (tkOp != null && tkOp.isOperator() && !tkOp.isOperator(new Integer(29)) && !tkOp.isOperator(new Integer(30))) {
                        ASTNode tkLA = this.nextTokenSkipSymbols();
                        if (tkLA != null && tkLA.isLiteral()) {
                            ASTNode tkOp2;
                            int op = tkOp.getOperator();
                            this.stk.push(tk.getLiteralValue(), tkLA.getLiteralValue(), new Integer(op));
                            if (ExpressionCompiler.isArithmeticOperator(op)) {
                                this.arithmeticFunctionReduction(op);
                            } else {
                                this.reduce();
                            }
                            boolean firstLA = true;
                            while ((tkOp2 = this.nextTokenSkipSymbols()) != null) {
                                if (ExpressionCompiler.isBooleanOperator(tkOp2.getOperator())) {
                                    astLinkedList.addTokenNode(new LiteralNode(this.stk.pop()), this.verify(this.pCtx, tkOp2));
                                    break;
                                }
                                ASTNode tkLA2 = this.nextTokenSkipSymbols();
                                if (tkLA2 != null && tkLA2.isLiteral()) {
                                    op = tkOp2.getOperator();
                                    this.stk.push(tkLA2.getLiteralValue(), new Integer(op));
                                    if (ExpressionCompiler.isArithmeticOperator(op)) {
                                        this.arithmeticFunctionReduction(op);
                                    } else {
                                        this.reduce();
                                    }
                                    firstLA = false;
                                    this.literalOnly = false;
                                    continue;
                                }
                                if (firstLA) {
                                    astLinkedList.addTokenNode(new LiteralNode(this.stk.pop()));
                                    break;
                                }
                                astLinkedList.addTokenNode(new LiteralNode(this.stk.pop()), tkOp);
                                if (tkLA2 == null) break;
                                astLinkedList.addTokenNode(tkLA2);
                                break;
                            }
                            if (this.stk.isEmpty()) continue;
                            astLinkedList.addTokenNode(new LiteralNode(this.stk.pop()));
                            continue;
                        }
                        this.literalOnly = false;
                        astLinkedList.addTokenNode(this.verify(this.pCtx, tk), this.verify(this.pCtx, tkOp));
                        if (tkLA == null) continue;
                        astLinkedList.addTokenNode(this.verify(this.pCtx, tkLA));
                        continue;
                    }
                    this.literalOnly = false;
                    astLinkedList.addTokenNode(this.verify(this.pCtx, tk));
                    if (tkOp == null) continue;
                    astLinkedList.addTokenNode(this.verify(this.pCtx, tkOp));
                    continue;
                }
                this.literalOnly = false;
                astLinkedList.addTokenNode(this.verify(this.pCtx, tk));
            }
            if (this.verifying) {
                this.pCtx.processTables();
            }
            astLinkedList.finish();
            if (!this.stk.isEmpty()) {
                throw new CompileException("COMPILE ERROR: non-empty stack after compile.");
            }
            return new CompiledExpression(CompilerTools.optimizeAST(astLinkedList, this.secondPassOptimization), ExpressionCompiler.getCurrentSourceFileName(), this.returnType, this.pCtx, this.literalOnly);
        }
        catch (Throwable e) {
            parserContext.set(null);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CompileException(e.getMessage(), e);
        }
    }

    private static boolean isBooleanOperator(int operator) {
        return operator == 20 || operator == 21;
    }

    protected ASTNode verify(ParserContext pCtx, ASTNode tk) {
        if (tk.isOperator() && (tk.isOperator(new Integer(20)) || tk.isOperator(new Integer(21)))) {
            this.secondPassOptimization = true;
        }
        if (tk.isDiscard() || tk.isOperator()) {
            return tk;
        }
        if (tk.isLiteral()) {
            if ((this.fields & 0x10) != 0) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.mvel.ASTNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (tk.getClass() == clazz) {
                    return new LiteralNode(tk.getLiteralValue());
                }
            }
            return tk;
        }
        if (this.verifying) {
            if (tk.isAssignment()) {
                String varName;
                char[] assign = tk.getNameAsArray();
                int c = 0;
                while (c < assign.length && assign[c] != '=') {
                    ++c;
                }
                if (ExpressionCompiler.isReservedWord(varName = new String(assign, 0, c++).trim())) {
                    this.addFatalError("invalid assignment - variable name is a reserved keyword: " + varName);
                }
                new ExpressionCompiler(new String(assign, c, assign.length - c).trim())._compile();
                if (((Assignment)((Object)tk)).isNewDeclaration() && pCtx.hasVarOrInput(varName)) {
                    throw new CompileException("statically-typed variable '" + varName + "' defined more than once in scope");
                }
                this.returnType = tk.getEgressType();
                pCtx.addVariable(varName, this.returnType);
            } else if (tk.isIdentifier()) {
                PropertyVerifier propVerifier = new PropertyVerifier(tk.getNameAsArray(), this.getParserContext());
                this.returnType = propVerifier.analyze();
                if (propVerifier.isResolvedExternally()) {
                    pCtx.addInput(tk.getAbsoluteName(), this.returnType);
                }
            } else {
                this.returnType = tk.getEgressType();
            }
        }
        return tk;
    }

    public ExpressionCompiler(String expression) {
        this.setExpression(expression);
    }

    public ExpressionCompiler(String expression, boolean verifying) {
        this.setExpression(expression);
        this.verifying = verifying;
    }

    public ExpressionCompiler(char[] expression) {
        this.setExpression(expression);
    }

    ExpressionCompiler(char[] expression, ParserContext ctx) {
        this.setExpression(expression);
        this.pCtx = ctx;
    }

    public boolean isVerifying() {
        return this.verifying;
    }

    public void setVerifying(boolean verifying) {
        this.verifying = verifying;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class returnType) {
        this.returnType = returnType;
    }

    public String getExpression() {
        return new String(this.expr);
    }

    public ParserContext getParserContextState() {
        return this.pCtx;
    }

    public void removeParserContext() {
        this.removeContext();
    }

    public boolean isLiteralOnly() {
        return this.literalOnly;
    }
}

