/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.datastore;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eurekaclinical.datastore.BdbMap;
import org.eurekaclinical.datastore.BdbStoreShutdownHook;
import org.eurekaclinical.datastore.DataStoreError;
import org.eurekaclinical.datastore.DataStoreUtil;
import org.eurekaclinical.datastore.EnvironmentInfo;

public abstract class BdbStoreFactory<E, V> {
    private EnvironmentInfo envInfo;
    private final File envFile;
    private final List<Database> databaseHandles;
    private final BdbStoreShutdownHook shutdownHook;

    protected BdbStoreFactory(String pathname, boolean deleteOnExit) {
        assert (pathname != null) : "pathname cannot be null";
        this.envFile = new File(pathname);
        this.databaseHandles = Collections.synchronizedList(new ArrayList());
        this.shutdownHook = new BdbStoreShutdownHook(deleteOnExit);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public final void shutdown() throws IOException {
        try {
            this.shutdownHook.shutdown();
        }
        catch (DatabaseException ex) {
            throw new DataStoreError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BdbMap<E, V> newInstance(String dbName) {
        if (dbName == null) {
            throw new IllegalArgumentException("dbName cannot be null");
        }
        BdbStoreFactory bdbStoreFactory = this;
        synchronized (bdbStoreFactory) {
            if (this.envInfo == null) {
                this.createEnvironmentInfo();
            }
        }
        DatabaseConfig dbConfig = this.createDatabaseConfig();
        Database databaseHandle = this.envInfo.getEnvironment().openDatabase(null, dbName, dbConfig);
        this.databaseHandles.add(databaseHandle);
        return new BdbMap(this.envInfo, databaseHandle);
    }

    protected abstract EnvironmentConfig createEnvConfig();

    protected abstract DatabaseConfig createDatabaseConfig();

    protected abstract StoredClassCatalog createClassCatalog(Environment var1);

    final void closeAndRemoveDatabaseHandle(Database databaseHandle) {
        databaseHandle.close();
        this.databaseHandles.remove(databaseHandle);
    }

    final void closeAndRemoveAllDatabaseHandles() {
        for (Database databaseHandle : this.databaseHandles) {
            databaseHandle.close();
        }
        this.databaseHandles.clear();
    }

    private void createEnvironmentInfo() {
        Environment env = this.createEnvironment();
        StoredClassCatalog classCatalog = this.createClassCatalog(env);
        this.envInfo = new EnvironmentInfo(env, classCatalog, this);
        this.shutdownHook.addEnvironmentInfo(this.envInfo);
    }

    private Environment createEnvironment() throws DatabaseException, IllegalArgumentException {
        EnvironmentConfig envConf = this.createEnvConfig();
        if (!this.envFile.exists()) {
            this.envFile.mkdirs();
        }
        DataStoreUtil.logger().log(Level.INFO, "Initialized BerkeleyDB cache environment at {0}", this.envFile.getAbsolutePath());
        return new Environment(this.envFile, envConf);
    }
}

