/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.InClause;
import org.protempa.backend.dsb.relationaldb.SqlGeneratorUtil;
import org.protempa.backend.dsb.relationaldb.TableAliaser;

public abstract class AbstractInClause
implements InClause {
    private final ColumnSpec columnSpec;
    private final Object[] elements;
    private final boolean not;
    private final TableAliaser referenceIndices;

    protected AbstractInClause(ColumnSpec columnSpec, Object[] elements, boolean not, TableAliaser referenceIndices) {
        this.columnSpec = columnSpec;
        this.elements = elements;
        this.not = not;
        this.referenceIndices = referenceIndices;
    }

    @Override
    public String generateClause() {
        StringBuilder result = new StringBuilder();
        result.append(this.referenceIndices.generateColumnReference(this.columnSpec));
        if (this.not) {
            result.append(" NOT");
        }
        result.append(" IN (");
        for (int k = 0; k < this.elements.length; ++k) {
            Object sqlCode = this.elements[k];
            result.append(SqlGeneratorUtil.prepareValue(sqlCode));
            if (k + 1 >= this.elements.length) continue;
            result.append(',');
        }
        result.append(')');
        return result.toString();
    }
}

