/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.ColumnSpecInfo;
import org.protempa.backend.dsb.relationaldb.ColumnSpecInfoFactory;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.FromClause;
import org.protempa.backend.dsb.relationaldb.IntColumnSpecWrapper;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;
import org.protempa.backend.dsb.relationaldb.SQLOrderBy;
import org.protempa.backend.dsb.relationaldb.SelectClause;
import org.protempa.backend.dsb.relationaldb.SelectStatement;
import org.protempa.backend.dsb.relationaldb.StagingSpec;
import org.protempa.backend.dsb.relationaldb.TableAliaser;
import org.protempa.backend.dsb.relationaldb.WhereClause;

public abstract class AbstractSelectStatement
implements SelectStatement {
    private final EntitySpec entitySpec;
    private final ReferenceSpec referenceSpec;
    private final List<EntitySpec> entitySpecs;
    private final Map<String, ReferenceSpec> inboundReferenceSpecs;
    private final Set<Filter> filters;
    private final Set<String> propIds;
    private final Set<String> keyIds;
    private final SQLOrderBy order;
    private final SQLGenResultProcessor resultProcessor;
    private final StagingSpec[] stagedTables;
    private final boolean streamingMode;
    private final boolean wrapKeyId;

    protected AbstractSelectStatement(EntitySpec entitySpec, ReferenceSpec referenceSpec, List<EntitySpec> entitySpecs, Map<String, ReferenceSpec> inboundReferenceSpecs, Set<Filter> filters, Set<String> propIds, Set<String> keyIds, SQLOrderBy order, SQLGenResultProcessor resultProcessor, StagingSpec[] stagedTables, boolean streamingMode, boolean wrapKeyId) {
        this.entitySpec = entitySpec;
        this.referenceSpec = referenceSpec;
        this.entitySpecs = Collections.unmodifiableList(entitySpecs);
        this.inboundReferenceSpecs = Collections.unmodifiableMap(inboundReferenceSpecs);
        this.filters = Collections.unmodifiableSet(filters);
        this.propIds = Collections.unmodifiableSet(propIds);
        this.keyIds = Collections.unmodifiableSet(keyIds);
        this.order = order;
        this.resultProcessor = resultProcessor;
        this.stagedTables = stagedTables;
        this.streamingMode = streamingMode;
        this.wrapKeyId = wrapKeyId;
    }

    protected EntitySpec getEntitySpec() {
        return this.entitySpec;
    }

    protected ReferenceSpec getReferenceSpec() {
        return this.referenceSpec;
    }

    protected List<EntitySpec> getEntitySpecs() {
        return this.entitySpecs;
    }

    protected Map<String, ReferenceSpec> getInboundReferenceSpecs() {
        return this.inboundReferenceSpecs;
    }

    protected Set<Filter> getFilters() {
        return this.filters;
    }

    protected Set<String> getPropIds() {
        return this.propIds;
    }

    protected Set<String> getKeyIds() {
        return this.keyIds;
    }

    protected SQLOrderBy getOrder() {
        return this.order;
    }

    protected SQLGenResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }

    protected StagingSpec[] getStagedTables() {
        return this.stagedTables;
    }

    protected abstract SelectClause getSelectClause(ColumnSpecInfo var1, TableAliaser var2, EntitySpec var3, boolean var4);

    protected abstract FromClause getFromClause(List<ColumnSpec> var1, TableAliaser var2, StagingSpec[] var3);

    protected abstract WhereClause getWhereClause(Set<String> var1, ColumnSpecInfo var2, List<EntitySpec> var3, Set<Filter> var4, TableAliaser var5, Set<String> var6, SQLOrderBy var7, SQLGenResultProcessor var8, SelectClause var9, StagingSpec[] var10);

    @Override
    public String generateStatement() {
        ColumnSpecInfo info = new ColumnSpecInfoFactory().newInstance(this.propIds, this.entitySpec, this.entitySpecs, this.inboundReferenceSpecs, this.filters, this.referenceSpec, this.streamingMode);
        TableAliaser referenceIndices = new TableAliaser(info.getColumnSpecs(), "a");
        SelectClause select = this.getSelectClause(info, referenceIndices, this.entitySpec, this.wrapKeyId);
        FromClause from = this.getFromClause(this.toColumnSpecs(info.getColumnSpecs()), referenceIndices, this.stagedTables);
        WhereClause where = this.getWhereClause(this.propIds, info, this.entitySpecs, this.filters, referenceIndices, this.keyIds, this.order, this.resultProcessor, select, this.stagedTables);
        StringBuilder result = new StringBuilder(select.generateClause()).append(" ").append(from.generateClause()).append(" ").append(where.generateClause());
        return result.toString();
    }

    protected final List<ColumnSpec> toColumnSpecs(List<IntColumnSpecWrapper> columnSpecWrappers) {
        ArrayList<ColumnSpec> result = new ArrayList<ColumnSpec>();
        for (IntColumnSpecWrapper icsw : columnSpecWrappers) {
            result.add(icsw.getColumnSpec());
        }
        return result;
    }
}

