/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.relationaldb.CreateStatement;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;
import org.protempa.backend.dsb.relationaldb.SQLOrderBy;
import org.protempa.backend.dsb.relationaldb.SelectStatement;
import org.protempa.backend.dsb.relationaldb.StagingSpec;

public abstract class AbstractStagingCreateStatement
implements CreateStatement {
    private final StagingSpec stagingSpec;
    private final EntitySpec currentSpec;
    private final ReferenceSpec referenceSpec;
    private final List<EntitySpec> entitySpecs;
    private final Set<Filter> filters;
    private final Set<String> propIds;
    private final Set<String> keyIds;
    private final SQLOrderBy order;
    private final SQLGenResultProcessor resultProcessor;
    private final boolean streamingMode;

    protected AbstractStagingCreateStatement(StagingSpec stagingSpec, EntitySpec currentSpec, ReferenceSpec referenceSpec, List<EntitySpec> entitySpecs, Set<Filter> filters, Set<String> propIds, Set<String> keyIds, SQLOrderBy order, SQLGenResultProcessor resultProcessor, boolean streamingMode) {
        this.stagingSpec = stagingSpec;
        this.currentSpec = currentSpec;
        this.referenceSpec = referenceSpec;
        this.entitySpecs = entitySpecs;
        this.filters = filters;
        this.propIds = propIds;
        this.keyIds = keyIds;
        this.order = order;
        this.resultProcessor = resultProcessor;
        this.streamingMode = streamingMode;
    }

    protected StagingSpec getStagingSpec() {
        return this.stagingSpec;
    }

    protected EntitySpec getCurrentSpec() {
        return this.currentSpec;
    }

    protected ReferenceSpec getReferenceSpec() {
        return this.referenceSpec;
    }

    protected List<EntitySpec> getEntitySpecs() {
        return this.entitySpecs;
    }

    protected Set<Filter> getFilters() {
        return this.filters;
    }

    protected Set<String> getPropIds() {
        return this.propIds;
    }

    protected Set<String> getKeyIds() {
        return this.keyIds;
    }

    protected SQLOrderBy getOrder() {
        return this.order;
    }

    protected SQLGenResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }

    @Override
    public String generateStatement() {
        return "CREATE TABLE " + this.stagingSpec.getStagingArea().getSchema() + "." + this.stagingSpec.getStagingArea().getTable() + " AS " + this.getSelectStatement(this.currentSpec, this.referenceSpec, Collections.singletonList(this.currentSpec), this.filters, this.propIds, this.keyIds, this.order, this.resultProcessor, this.streamingMode).generateStatement();
    }

    @Override
    public abstract SelectStatement getSelectStatement(EntitySpec var1, ReferenceSpec var2, List<EntitySpec> var3, Set<Filter> var4, Set<String> var5, Set<String> var6, SQLOrderBy var7, SQLGenResultProcessor var8, boolean var9);
}

