/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.protempa.DataSourceBackendSourceSystem;
import org.protempa.DataStreamingEventIterator;
import org.protempa.SourceSystem;
import org.protempa.UniqueIdPair;
import org.protempa.backend.dsb.relationaldb.AbstractResultProcessor;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EmptyDataStreamingEventIterator;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.InboundReferenceResultSetIterator;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.PropositionResultSetIterator;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.backend.dsb.relationaldb.StreamingMainResultProcessor;
import org.protempa.proposition.Constant;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;

class ConstantStreamingResultProcessor
extends StreamingMainResultProcessor<Constant> {
    private static final DataStreamingEventIterator<UniqueIdPair> EMPTY_UNIQUE_ID_PAIR_ITR = new EmptyDataStreamingEventIterator<UniqueIdPair>();
    private static final DataStreamingEventIterator<Constant> EMPTY_CONSTANT_ITR = new EmptyDataStreamingEventIterator<Constant>();
    private ConstantIterator itr;
    private final Set<String> queryPropIds;

    ConstantStreamingResultProcessor(EntitySpec entitySpec, LinkedHashMap<String, ReferenceSpec> inboundRefSpecs, Map<String, ReferenceSpec> bidirectionalRefSpecs, String dataSourceBackendId, Set<String> propIds) {
        super(entitySpec, inboundRefSpecs, bidirectionalRefSpecs, dataSourceBackendId);
        assert (propIds != null) : "propIds cannot be null";
        this.queryPropIds = propIds;
    }

    public void process(ResultSet resultSet) throws SQLException {
        EntitySpec entitySpec = this.getEntitySpec();
        this.itr = new ConstantIterator(this.getStatement(), resultSet, entitySpec, this.getInboundRefSpecs(), this.getBidirectionalRefSpecs(), new InboundReferenceResultSetIterator(entitySpec.getName()));
    }

    @Override
    final DataStreamingEventIterator<Constant> getResults() {
        if (this.itr != null) {
            return this.itr;
        }
        return EMPTY_CONSTANT_ITR;
    }

    @Override
    final DataStreamingEventIterator<UniqueIdPair> getInboundReferenceResults() {
        if (this.itr != null) {
            return this.itr.getReferenceIterator();
        }
        return EMPTY_UNIQUE_ID_PAIR_ITR;
    }

    class ConstantIterator
    extends PropositionResultSetIterator<Constant> {
        private final Logger logger;
        private final DataSourceBackendSourceSystem dsType;
        private final Date now;

        ConstantIterator(Statement statement, ResultSet resultSet, EntitySpec entitySpec, LinkedHashMap<String, ReferenceSpec> inboundRefSpecs, Map<String, ReferenceSpec> bidirectionalRefSpecs, InboundReferenceResultSetIterator referenceIterator) throws SQLException {
            super(statement, resultSet, entitySpec, inboundRefSpecs, bidirectionalRefSpecs, ConstantStreamingResultProcessor.this.getDataSourceBackendId(), referenceIterator);
            this.logger = SQLGenUtil.logger();
            this.dsType = DataSourceBackendSourceSystem.getInstance((String)ConstantStreamingResultProcessor.this.getDataSourceBackendId());
            this.now = new Date();
        }

        @Override
        void doProcess(ResultSet resultSet, String[] uniqueIds, ColumnSpec codeSpec, EntitySpec entitySpec, Map<String, ReferenceSpec> bidirectionalRefSpecs, int[] columnTypes, String[] propIds, PropertySpec[] propertySpecs, Value[] propertyValues, UniqueIdPair[] refUniqueIds) throws SQLException {
            String kId;
            int i = 1;
            if ((kId = resultSet.getString(i++)) == null) {
                this.logger.warning("A keyId is null. Skipping record.");
                return;
            }
            this.handleKeyId(kId);
            i = AbstractResultProcessor.readUniqueIds(uniqueIds, resultSet, i);
            if (Arrays.contains((Object[])uniqueIds, null)) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "Unique ids contain null ({0}). Skipping record.", StringUtils.join((Object[])uniqueIds, (String)", "));
                }
                this.getReferenceIterator().addUniqueIds(kId, null);
                return;
            }
            UniqueId uniqueId = ConstantStreamingResultProcessor.this.generateUniqueId(entitySpec.getName(), uniqueIds);
            String propId = null;
            if (!ConstantStreamingResultProcessor.this.isCasePresent()) {
                String code;
                if (codeSpec == null) {
                    assert (propIds.length == 1) : "Don't know which proposition id to assign to";
                    propId = propIds[0];
                } else if ((propId = StreamingMainResultProcessor.sqlCodeToPropositionId(codeSpec, code = resultSet.getString(i++))) == null) {
                    this.getReferenceIterator().addUniqueIds(kId, null);
                    return;
                }
            } else {
                ++i;
            }
            i = ConstantStreamingResultProcessor.this.extractPropertyValues(resultSet, i, propertyValues, columnTypes);
            i = ConstantStreamingResultProcessor.this.extractReferenceUniqueIdPairs(resultSet, uniqueId, refUniqueIds, i);
            this.getReferenceIterator().addUniqueIds(kId, refUniqueIds);
            if (ConstantStreamingResultProcessor.this.isCasePresent()) {
                propId = resultSet.getString(i++);
            }
            if (!ConstantStreamingResultProcessor.this.queryPropIds.contains(propId)) {
                return;
            }
            Constant cp = new Constant(propId, uniqueId);
            for (int j = 0; j < propertySpecs.length; ++j) {
                PropertySpec propertySpec = propertySpecs[j];
                cp.setProperty(propertySpec.getName(), propertyValues[j]);
            }
            cp.setSourceSystem((SourceSystem)this.dsType);
            if (entitySpec.getCreateDateSpec() != null) {
                cp.setCreateDate((Date)resultSet.getTimestamp(i++));
            }
            if (entitySpec.getUpdateDateSpec() != null) {
                cp.setUpdateDate((Date)resultSet.getTimestamp(i++));
            }
            if (entitySpec.getDeleteDateSpec() != null) {
                cp.setDeleteDate((Date)resultSet.getTimestamp(i++));
            }
            cp.setDownloadDate(this.now);
            this.handleProposition(cp);
            this.logger.log(Level.FINEST, "Created constant {0}", cp);
        }

        @Override
        void fireResultSetCompleted() {
            this.getReferenceIterator().resultSetComplete();
        }
    }
}

