/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.log.Logging;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamingEvent;
import org.protempa.DataStreamingEventIterator;
import org.protempa.UniqueIdPair;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.InboundReferenceResultSetIterator;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.backend.dsb.relationaldb.StreamingSQLException;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;

abstract class PropositionResultSetIterator<P extends Proposition>
implements DataStreamingEventIterator<P> {
    private ResultSet resultSet;
    private final Logger logger;
    private final String[] uniqueIds;
    private final EntitySpec entitySpec;
    private final int[] columnTypes;
    private Statement statement;
    private int count;
    private ColumnSpec codeSpec;
    private String[] propIds;
    private PropertySpec[] propertySpecs;
    private Value[] propertyValues;
    private Map<String, ReferenceSpec> inboundRefSpecs;
    private UniqueIdPair[] refUniqueIds;
    private Map<String, ReferenceSpec> bidirectionalRefSpecs;
    private Map<UniqueId, P> props;
    private DataStreamingEvent<P> dataStreamingEvent;
    private String keyId;
    private boolean end;
    private InboundReferenceResultSetIterator referenceIterator;
    private boolean advanceInvoked = false;

    PropositionResultSetIterator(Statement statement, ResultSet resultSet, EntitySpec entitySpec, Map<String, ReferenceSpec> inboundRefSpecs, Map<String, ReferenceSpec> bidirectionalRefSpecs, String dataSourceBackendId, InboundReferenceResultSetIterator referenceIterator) throws SQLException {
        assert (resultSet != null) : "resultSet cannot be null";
        assert (entitySpec != null) : "entitySpec cannot be null";
        assert (dataSourceBackendId != null) : "dataSourceBackendId cannot be null";
        this.resultSet = resultSet;
        this.logger = SQLGenUtil.logger();
        this.logger.log(Level.INFO, "Creating proposition iterator for {0}", new Object[]{entitySpec.getName()});
        this.uniqueIds = new String[entitySpec.getUniqueIdSpecs().length];
        this.entitySpec = entitySpec;
        this.propIds = entitySpec.getPropositionIds();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.columnTypes = new int[resultSetMetaData.getColumnCount()];
        for (int i = 0; i < this.columnTypes.length; ++i) {
            this.columnTypes[i] = resultSetMetaData.getColumnType(i + 1);
        }
        ColumnSpec localCodeSpec = entitySpec.getCodeSpec();
        if (localCodeSpec != null) {
            List<ColumnSpec> codeSpecL = localCodeSpec.asList();
            localCodeSpec = codeSpecL.get(codeSpecL.size() - 1);
        }
        this.codeSpec = localCodeSpec;
        this.propertySpecs = entitySpec.getPropertySpecs();
        this.propertyValues = new Value[this.propertySpecs.length];
        this.referenceIterator = referenceIterator;
        this.inboundRefSpecs = inboundRefSpecs;
        this.bidirectionalRefSpecs = bidirectionalRefSpecs;
        this.refUniqueIds = new UniqueIdPair[this.inboundRefSpecs.size() + this.bidirectionalRefSpecs.size()];
        this.props = new HashMap<UniqueId, P>();
        this.statement = statement;
    }

    final String getKeyId() {
        return this.keyId;
    }

    final InboundReferenceResultSetIterator getReferenceIterator() {
        return this.referenceIterator;
    }

    final void handleKeyId(String kId) {
        String oldKeyId = this.getKeyId();
        if (oldKeyId != null && !oldKeyId.equals(kId)) {
            this.createDataStreamingEvent(oldKeyId, this.props);
        }
        this.keyId = kId;
    }

    abstract void fireResultSetCompleted();

    void handleProposition(P prop) {
        if (!this.props.containsKey(prop.getUniqueId())) {
            this.props.put(prop.getUniqueId(), prop);
        }
    }

    abstract void doProcess(ResultSet var1, String[] var2, ColumnSpec var3, EntitySpec var4, Map<String, ReferenceSpec> var5, int[] var6, String[] var7, PropertySpec[] var8, Value[] var9, UniqueIdPair[] var10) throws SQLException;

    private void createDataStreamingEvent(String key, Map<UniqueId, P> propositions) {
        ArrayList<P> uniqueProps = new ArrayList<P>(propositions.values());
        this.dataStreamingEvent = new DataStreamingEvent(key, uniqueProps);
        this.props = new HashMap<UniqueId, P>();
    }

    public boolean hasNext() {
        return this.dataStreamingEvent != null || this.advance() != null;
    }

    public final DataStreamingEvent<P> next() {
        DataStreamingEvent<P> result = this.dataStreamingEvent != null ? this.dataStreamingEvent : this.advance();
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.dataStreamingEvent = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private DataStreamingEvent<P> advance() throws StreamingSQLException {
        block39: {
            if (!this.advanceInvoked) {
                this.advanceInvoked = true;
                this.logger.log(Level.INFO, "First invocation of advance() for {0} proposition iterator <{1}>", new Object[]{this.entitySpec.getName(), this.hashCode()});
            }
            if (this.end) {
                return null;
            }
            boolean normalExit = true;
            if (this.resultSet != null) {
                try {
                    block37: {
                        DataStreamingEvent<P> dataStreamingEvent;
                        block38: {
                            while (this.dataStreamingEvent == null) {
                                if (this.resultSet.next()) {
                                    this.doProcess(this.resultSet, this.uniqueIds, this.codeSpec, this.entitySpec, this.bidirectionalRefSpecs, this.columnTypes, this.propIds, this.propertySpecs, this.propertyValues, this.refUniqueIds);
                                    ++this.count;
                                    continue;
                                }
                                this.logger.log(Level.INFO, "Result set complete for {0} proposition iterator", this.entitySpec.getName());
                                this.end = true;
                                this.fireResultSetCompleted();
                                break;
                            }
                            if (this.dataStreamingEvent == null) break block37;
                            dataStreamingEvent = this.dataStreamingEvent;
                            if (normalExit || this.resultSet == null) break block38;
                            try {
                                this.resultSet.close();
                                this.resultSet = null;
                            }
                            catch (SQLException sQLException) {
                                this.resultSet = null;
                            }
                            catch (Throwable throwable) {
                                this.resultSet = null;
                                throw throwable;
                            }
                        }
                        return dataStreamingEvent;
                    }
                    if (this.end) {
                        this.resultSet.close();
                        this.resultSet = null;
                        this.statement.close();
                        this.statement = null;
                    }
                    if (normalExit || this.resultSet == null) break block39;
                    try {
                        this.resultSet.close();
                        this.resultSet = null;
                        break block39;
                    }
                    catch (SQLException sQLException) {
                        this.resultSet = null;
                        break block39;
                    }
                    catch (Throwable throwable) {
                        this.resultSet = null;
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        try {
                            normalExit = false;
                            throw new StreamingSQLException("Error during streaming entity " + this.entitySpec.getName(), ex);
                        }
                        catch (Throwable throwable) {
                            if (!normalExit && this.resultSet != null) {
                                try {
                                    this.resultSet.close();
                                }
                                catch (SQLException sQLException) {
                                }
                                finally {
                                    this.resultSet = null;
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (!normalExit && this.statement != null) {
                        try {
                            this.statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        }
        if (this.resultSet == null && this.logger.isLoggable(Level.FINE)) {
            Logging.logCount((Logger)this.logger, (Level)Level.FINE, (int)this.count, (String)"Retrieved {0} record total", (String)"Retrieved {0} records total");
        }
        assert (this.dataStreamingEvent == null) : "dataStreamingEvent should be null";
        if (this.keyId != null) {
            this.createDataStreamingEvent(this.keyId, this.props);
        }
        return this.dataStreamingEvent;
    }

    public final void close() throws DataSourceReadException {
        block13: {
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                    this.resultSet = null;
                    if (this.statement == null) break block13;
                    try {
                        this.statement.close();
                        this.statement = null;
                    }
                    catch (SQLException ex) {
                        throw new DataSourceReadException("Error closing statement", (Throwable)ex);
                    }
                }
                catch (SQLException ex) {
                    throw new DataSourceReadException("Error closing result set", (Throwable)ex);
                }
                finally {
                    if (this.statement != null) {
                        try {
                            this.statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        }
    }
}

