/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.sql.ConnectionSpec;
import org.arp.javautil.sql.DatabaseAPI;
import org.arp.javautil.sql.InvalidConnectionSpecArguments;
import org.protempa.BackendCloseException;
import org.protempa.DataSourceReadException;
import org.protempa.DataSourceWriteException;
import org.protempa.DataStreamingEventIterator;
import org.protempa.KeySetSpec;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.QuerySession;
import org.protempa.SourceSystem;
import org.protempa.backend.AbstractCommonsDataSourceBackend;
import org.protempa.backend.BackendInitializationException;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.DataSourceBackendFailedConfigurationValidationException;
import org.protempa.backend.DataSourceBackendFailedDataValidationException;
import org.protempa.backend.annotations.BackendProperty;
import org.protempa.backend.dsb.DataValidationEvent;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.NoCompatibleSQLGeneratorException;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.RelationalDatabaseSpec;
import org.protempa.backend.dsb.relationaldb.RelationalDatabaseSpecBuilder;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.backend.dsb.relationaldb.SQLGenerator;
import org.protempa.backend.dsb.relationaldb.SQLGeneratorFactory;
import org.protempa.backend.dsb.relationaldb.SQLGeneratorLoadException;
import org.protempa.backend.dsb.relationaldb.StagingSpec;
import org.protempa.backend.dsb.relationaldb.mappings.DelimFileMappingsFactory;
import org.protempa.backend.dsb.relationaldb.mappings.MappingsFactory;
import org.protempa.backend.dsb.relationaldb.mappings.ResourceMappingsFactory;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.keyloader.KeyLoaderQueryResultsHandler;
import org.protempa.proposition.Proposition;

public abstract class RelationalDbDataSourceBackend
extends AbstractCommonsDataSourceBackend {
    private static final DataValidationEvent[] EMPTY_VALIDATION_EVENT_ARRAY = new DataValidationEvent[0];
    private DatabaseAPI databaseAPI = DatabaseAPI.DRIVERMANAGER;
    private String databaseId;
    protected String username;
    private String password;
    private SQLGenerator sqlGenerator;
    private Integer queryTimeout;
    private boolean dryRun = Boolean.getBoolean("protempa.dsb.relationaldatabase.skipexecution");
    private String schemaName;
    private String defaultKeyIdTable;
    private String defaultKeyIdColumn;
    private String defaultKeyIdJoinKey;
    private String keyLoaderKeyIdSchema;
    private String keyLoaderKeyIdTable;
    private String keyLoaderKeyIdColumn;
    private String keyLoaderKeyIdJoinKey;
    private FromBackendRelationalDatabaseSpecBuilder relationalDatabaseSpecBuilder;
    private MappingsFactory mappingsFactory;
    private Integer queryThreadCount;

    public MappingsFactory getMappingsFactory() {
        return this.mappingsFactory;
    }

    public void setMappingsFactory(MappingsFactory mappingsFactory) {
        this.mappingsFactory = mappingsFactory == null ? new ResourceMappingsFactory("/etc/i2b2dsb/", ((Object)((Object)this)).getClass()) : mappingsFactory;
    }

    @BackendProperty(propertyName="mappings")
    public void parseMappingsFactory(String pathname) {
        this.mappingsFactory = new DelimFileMappingsFactory(pathname);
    }

    @BackendProperty
    public final void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public final String getSchemaName() {
        return this.schemaName;
    }

    @BackendProperty
    public final void setDefaultKeyIdTable(String defaultKeyIdTable) {
        this.defaultKeyIdTable = defaultKeyIdTable;
    }

    public final String getDefaultKeyIdTable() {
        return this.defaultKeyIdTable;
    }

    @BackendProperty
    public final void setDefaultKeyIdColumn(String defaultKeyIdColumn) {
        this.defaultKeyIdColumn = defaultKeyIdColumn;
    }

    public final String getDefaultKeyIdColumn() {
        return this.defaultKeyIdColumn;
    }

    @BackendProperty
    public final void setKeyLoaderKeyIdSchema(String keyLoaderKeyIdSchema) {
        this.keyLoaderKeyIdSchema = keyLoaderKeyIdSchema;
    }

    public final String getKeyLoaderKeyIdSchema() {
        if (this.keyLoaderKeyIdSchema != null) {
            return this.keyLoaderKeyIdSchema;
        }
        return this.schemaName;
    }

    @BackendProperty
    public final void setDefaultKeyIdJoinKey(String defaultKeyIdJoinKey) {
        this.defaultKeyIdJoinKey = defaultKeyIdJoinKey;
    }

    public final String getDefaultKeyIdJoinKey() {
        return this.defaultKeyIdJoinKey;
    }

    public Integer getQueryThreadCount() {
        return this.queryThreadCount;
    }

    @BackendProperty
    public void setQueryThreadCount(Integer queryThreadCount) {
        this.queryThreadCount = queryThreadCount;
    }

    public String getKeyLoaderKeyIdTable() {
        if (this.keyLoaderKeyIdTable != null) {
            return this.keyLoaderKeyIdTable;
        }
        return this.defaultKeyIdTable;
    }

    @BackendProperty
    public void setKeyLoaderKeyIdTable(String keyLoaderKeyIdTable) {
        this.keyLoaderKeyIdTable = keyLoaderKeyIdTable;
    }

    public String getKeyLoaderKeyIdColumn() {
        if (this.keyLoaderKeyIdColumn != null) {
            return this.keyLoaderKeyIdColumn;
        }
        return this.defaultKeyIdColumn;
    }

    @BackendProperty
    public void setKeyLoaderKeyIdColumn(String keyLoaderKeyIdColumn) {
        this.keyLoaderKeyIdColumn = keyLoaderKeyIdColumn;
    }

    public String getKeyLoaderKeyIdJoinKey() {
        if (this.keyLoaderKeyIdJoinKey != null) {
            return this.keyLoaderKeyIdJoinKey;
        }
        return this.defaultKeyIdJoinKey;
    }

    @BackendProperty
    public void setKeyLoaderKeyIdJoinKey(String keyLoaderKeyIdJoinKey) {
        this.keyLoaderKeyIdJoinKey = keyLoaderKeyIdJoinKey;
    }

    public void initialize(BackendInstanceSpec config) throws BackendInitializationException {
        super.initialize(config);
        if (this.mappingsFactory == null) {
            this.setMappingsFactory(null);
        }
        this.relationalDatabaseSpecBuilder = this.createRelationalDatabaseSpecBuilder();
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @BackendProperty(propertyName="dryRun")
    public void parseDryRun(String dryRunString) {
        this.setDryRun(Boolean.parseBoolean(dryRunString));
    }

    public DatabaseAPI getDatabaseAPI() {
        return this.databaseAPI;
    }

    public void setDatabaseAPI(DatabaseAPI databaseAPI) {
        this.sqlGenerator = null;
        if (databaseAPI == null) {
            databaseAPI = DatabaseAPI.DRIVERMANAGER;
        }
        this.databaseAPI = databaseAPI;
    }

    @BackendProperty(propertyName="databaseAPI")
    public void parseDatabaseAPI(String databaseAPISTring) {
        this.setDatabaseAPI(DatabaseAPI.valueOf((String)databaseAPISTring));
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    @BackendProperty
    public void setDatabaseId(String databaseId) {
        this.sqlGenerator = null;
        this.databaseId = databaseId;
    }

    @BackendProperty
    public void setQueryTimeout(Integer seconds) {
        if (seconds != null && seconds < 0) {
            throw new IllegalArgumentException("invalid seconds: " + seconds);
        }
        this.queryTimeout = seconds;
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public String getUsername() {
        return this.username;
    }

    @BackendProperty
    public void setUsername(String user) {
        this.sqlGenerator = null;
        this.username = user;
    }

    public String getPassword() {
        return this.password;
    }

    @BackendProperty
    public void setPassword(String password) {
        this.sqlGenerator = null;
        this.password = password;
    }

    public boolean isInKeySetMode() {
        return this.keyLoaderKeyIdSchema != null || this.keyLoaderKeyIdTable != null;
    }

    public KeySetSpec[] getSelectedKeySetSpecs() throws DataSourceReadException {
        if (this.isInKeySetMode()) {
            return new KeySetSpec[]{new KeySetSpec((SourceSystem)this.getSourceSystem(), "Cohort", "Cohort", null)};
        }
        return KeySetSpec.EMPTY_KEY_SET_SPEC_ARRAY;
    }

    public DataStreamingEventIterator<Proposition> readPropositions(Set<String> keyIds, Set<String> propIds, Filter filters, QuerySession qs, QueryResultsHandler queryResultsHandler) throws DataSourceReadException {
        if (this.sqlGenerator == null) {
            try {
                ConnectionSpec connectionSpecInstance = this.getConnectionSpecInstance();
                this.sqlGenerator = new SQLGeneratorFactory(connectionSpecInstance, this.relationalDatabaseSpecBuilder.build(queryResultsHandler), this).newInstance();
            }
            catch (SQLException | InvalidConnectionSpecArguments | NoCompatibleSQLGeneratorException | SQLGeneratorLoadException ex) {
                throw new DataSourceReadException("Could not initialize data source backend " + this.nameForErrors(), ex);
            }
        }
        return this.sqlGenerator.readPropositionsStreaming(keyIds, propIds, filters);
    }

    public void deleteAllKeys() throws DataSourceWriteException {
        if (this.isInKeySetMode()) {
            try {
                ConnectionSpec connectionSpecInstance = this.getConnectionSpecInstance();
                try (Connection con = connectionSpecInstance.getOrCreate();){
                    try (Statement stmt = con.createStatement();){
                        StringBuilder stmtBuilder = new StringBuilder();
                        stmtBuilder.append("DELETE FROM ");
                        if (this.getKeyLoaderKeyIdSchema() != null) {
                            stmtBuilder.append(this.getKeyLoaderKeyIdSchema());
                            stmtBuilder.append('.');
                        }
                        stmtBuilder.append(this.getKeyLoaderKeyIdTable());
                        stmt.execute(stmtBuilder.toString());
                        con.commit();
                    }
                    catch (SQLException sqlex) {
                        try {
                            con.rollback();
                        }
                        catch (SQLException ignore) {
                            sqlex.addSuppressed(ignore);
                        }
                    }
                }
            }
            catch (SQLException | InvalidConnectionSpecArguments ex) {
                throw new DataSourceWriteException("Could not delete all key ids in data source backend " + this.nameForErrors(), ex);
            }
        } else {
            SQLGenUtil.logger().log(Level.FINER, "Unable to delete all keys in keyIdSchema{0}, keyIdTable={1} and keyIdColumn={2}", new Object[]{this.keyLoaderKeyIdSchema, this.defaultKeyIdTable, this.defaultKeyIdColumn});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeKeys(Set<String> keyIds) throws DataSourceWriteException {
        if (this.isInKeySetMode()) {
            int batchSize = 1000;
            int commitSize = 10000;
            try {
                ConnectionSpec connectionSpecInstance = this.getConnectionSpecInstance();
                try (Connection con = connectionSpecInstance.getOrCreate();){
                    try {
                        int i = 0;
                        ArrayList<String> subKeyIds = new ArrayList<String>(batchSize);
                        String stmt = this.buildWriteKeysInsertStmt(batchSize);
                        SQLGenUtil.logger().log(Level.FINER, "Statement for writing keys: {0}", stmt);
                        try (PreparedStatement prepareStatement = con.prepareStatement(stmt);){
                            for (String keyId : keyIds) {
                                subKeyIds.add(keyId);
                                if (++i % batchSize == 0) {
                                    int n = subKeyIds.size();
                                    for (int j = 0; j < n; ++j) {
                                        prepareStatement.setObject(j + 1, subKeyIds.get(j));
                                    }
                                    prepareStatement.execute();
                                }
                                if (i < commitSize) continue;
                                con.commit();
                                commitSize = 0;
                            }
                        }
                        if (!subKeyIds.isEmpty()) {
                            stmt = this.buildWriteKeysInsertStmt(subKeyIds.size());
                            SQLGenUtil.logger().log(Level.FINER, "Statement for writing keys: {0}", stmt);
                            i = 0;
                            prepareStatement = con.prepareStatement(stmt);
                            var11_16 = null;
                            try {
                                for (String subKeyId : subKeyIds) {
                                    prepareStatement.setObject(++i, subKeyId);
                                }
                                prepareStatement.execute();
                            }
                            catch (Throwable throwable) {
                                var11_16 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (prepareStatement != null) {
                                    if (var11_16 != null) {
                                        try {
                                            prepareStatement.close();
                                        }
                                        catch (Throwable throwable) {
                                            var11_16.addSuppressed(throwable);
                                        }
                                    } else {
                                        prepareStatement.close();
                                    }
                                }
                            }
                        }
                        if (i < commitSize) return;
                        con.commit();
                        commitSize = 0;
                        return;
                    }
                    catch (SQLException ex) {
                        if (commitSize <= 0) return;
                        try {
                            con.rollback();
                            return;
                        }
                        catch (SQLException ignore) {
                            ex.addSuppressed(ignore);
                        }
                    }
                    return;
                }
            }
            catch (SQLException | InvalidConnectionSpecArguments ex) {
                throw new DataSourceWriteException("Could not write key ids in data source backend " + this.nameForErrors(), ex);
            }
        }
        SQLGenUtil.logger().log(Level.FINER, "Unable to write keys to keyIdSchema{0}, keyIdTable={1} and keyIdColumn={2}", new Object[]{this.keyLoaderKeyIdSchema, this.defaultKeyIdTable, this.defaultKeyIdColumn});
    }

    private String buildWriteKeysInsertStmt(int size) {
        StringBuilder stmtBuilder = new StringBuilder();
        stmtBuilder.append("INSERT INTO ");
        if (this.getKeyLoaderKeyIdSchema() != null) {
            stmtBuilder.append(this.getKeyLoaderKeyIdSchema());
            stmtBuilder.append('.');
        }
        stmtBuilder.append(this.getKeyLoaderKeyIdTable());
        stmtBuilder.append(" (");
        stmtBuilder.append(this.getKeyLoaderKeyIdColumn());
        stmtBuilder.append(", ");
        stmtBuilder.append(this.getKeyLoaderKeyIdJoinKey());
        stmtBuilder.append(") ");
        stmtBuilder.append(" SELECT ");
        stmtBuilder.append(this.getDefaultKeyIdColumn());
        stmtBuilder.append(", ");
        stmtBuilder.append(this.getDefaultKeyIdJoinKey());
        stmtBuilder.append(" FROM ");
        if (this.getSchemaName() != null) {
            stmtBuilder.append(this.getSchemaName());
            stmtBuilder.append('.');
        }
        stmtBuilder.append(this.getDefaultKeyIdTable());
        stmtBuilder.append(" WHERE ");
        stmtBuilder.append(this.getDefaultKeyIdColumn());
        stmtBuilder.append(" IN (");
        stmtBuilder.append(StringUtils.join(Collections.nCopies(size, "?"), (char)','));
        stmtBuilder.append(')');
        String stmt = stmtBuilder.toString();
        return stmt;
    }

    public DataValidationEvent[] validateData(KnowledgeSource knowledgeSource) throws DataSourceBackendFailedDataValidationException, KnowledgeSourceReadException {
        return EMPTY_VALIDATION_EVENT_ARRAY;
    }

    public void validateConfiguration(KnowledgeSource knowledgeSource) throws DataSourceBackendFailedConfigurationValidationException, KnowledgeSourceReadException {
        this.validate(knowledgeSource);
    }

    private void validate(KnowledgeSource knowledgeSource) throws KnowledgeSourceReadException, DataSourceBackendFailedConfigurationValidationException {
        List allSpecs = Arrays.asList((Object[][])new EntitySpec[][]{this.relationalDatabaseSpecBuilder.getEventSpecs(), this.relationalDatabaseSpecBuilder.getConstantSpecs(), this.relationalDatabaseSpecBuilder.getPrimitiveParameterSpecs()});
        Logger logger = SQLGenUtil.logger();
        for (EntitySpec entitySpec : allSpecs) {
            String entitySpecName = entitySpec.getName();
            logger.log(Level.FINER, "Validating entity spec {0}", entitySpecName);
            String[] propIds = entitySpec.getPropositionIds();
            HashSet<String> propNamesFromPropSpecs = new HashSet<String>();
            PropertySpec[] propSpecs = entitySpec.getPropertySpecs();
            logger.finer("Checking for duplicate properties");
            for (PropertySpec propSpec : propSpecs) {
                String propSpecName = propSpec.getName();
                if (propNamesFromPropSpecs.add(propSpecName)) continue;
                throw new DataSourceBackendFailedConfigurationValidationException("Duplicate property name " + propSpecName + " in entity spec " + entitySpecName);
            }
            logger.finer("No duplicate properties found");
            logger.finer("Checking for invalid proposition ids and properties");
            HashSet<String> propNamesFromPropDefs = new HashSet<String>();
            HashSet<String> invalidPropIds = new HashSet<String>();
            for (String propId : propIds) {
                PropertyDefinition[] propertyDefs;
                PropositionDefinition propDef = knowledgeSource.readPropositionDefinition(propId);
                if (propDef == null) {
                    invalidPropIds.add(propId);
                }
                for (PropertyDefinition propertyDef : propertyDefs = propDef.getPropertyDefinitions()) {
                    String propName = propertyDef.getId();
                    propNamesFromPropDefs.add(propName);
                }
            }
            if (!invalidPropIds.isEmpty()) {
                throw new DataSourceBackendFailedConfigurationValidationException("Invalid proposition id(s) named in entity spec " + entitySpecName + ": '" + StringUtils.join(invalidPropIds, (String)"', '") + "'");
            }
            if (!propNamesFromPropSpecs.removeAll(propNamesFromPropDefs)) {
                throw new DataSourceBackendFailedConfigurationValidationException("Data model entity spec " + entitySpec.getName() + " has properties '" + StringUtils.join(propNamesFromPropSpecs, (String)"', '") + "' that are not in the knowledge source's corresponding proposition definitions");
            }
            logger.finer("No invalid proposition ids or properties found");
        }
    }

    public void close() throws BackendCloseException {
        this.sqlGenerator = null;
        if (this.mappingsFactory != null) {
            try {
                this.mappingsFactory.closeAll();
            }
            catch (IOException ex) {
                throw new BackendCloseException((Throwable)ex);
            }
        }
    }

    protected ConnectionSpec getConnectionSpecInstance() throws InvalidConnectionSpecArguments {
        return this.databaseAPI.newConnectionSpecInstance(this.databaseId, this.username, this.password, false);
    }

    protected abstract EntitySpec[] constantSpecs(String var1, String var2, String var3, String var4) throws IOException;

    protected abstract EntitySpec[] eventSpecs(String var1, String var2, String var3, String var4) throws IOException;

    protected abstract EntitySpec[] primitiveParameterSpecs(String var1, String var2, String var3, String var4) throws IOException;

    protected abstract StagingSpec[] stagedSpecs(String var1, String var2, String var3, String var4) throws IOException;

    private FromBackendRelationalDatabaseSpecBuilder createRelationalDatabaseSpecBuilder() {
        return new FromBackendRelationalDatabaseSpecBuilder();
    }

    private class FromBackendRelationalDatabaseSpecBuilder
    extends RelationalDatabaseSpecBuilder {
        private String keyIdSchema;
        private String keyIdTable;
        private String keyIdColumn;
        private String keyIdJoinKey;

        private FromBackendRelationalDatabaseSpecBuilder() {
        }

        @Override
        public StagingSpec[] getStagedSpecs() {
            try {
                return RelationalDbDataSourceBackend.this.stagedSpecs(this.keyIdSchema, this.keyIdTable, this.keyIdColumn, this.keyIdJoinKey);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public EntitySpec[] getPrimitiveParameterSpecs() {
            try {
                return RelationalDbDataSourceBackend.this.primitiveParameterSpecs(this.keyIdSchema, this.keyIdTable, this.keyIdColumn, this.keyIdJoinKey);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public EntitySpec[] getEventSpecs() {
            try {
                return RelationalDbDataSourceBackend.this.eventSpecs(this.keyIdSchema, this.keyIdTable, this.keyIdColumn, this.keyIdJoinKey);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public EntitySpec[] getConstantSpecs() {
            try {
                return RelationalDbDataSourceBackend.this.constantSpecs(this.keyIdSchema, this.keyIdTable, this.keyIdColumn, this.keyIdJoinKey);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        RelationalDatabaseSpec build(QueryResultsHandler queryResultsHandler) {
            if (queryResultsHandler instanceof KeyLoaderQueryResultsHandler) {
                this.keyIdSchema = RelationalDbDataSourceBackend.this.getSchemaName();
                this.keyIdTable = RelationalDbDataSourceBackend.this.getDefaultKeyIdTable();
                this.keyIdColumn = RelationalDbDataSourceBackend.this.getDefaultKeyIdColumn();
                this.keyIdJoinKey = RelationalDbDataSourceBackend.this.getDefaultKeyIdJoinKey();
            } else {
                this.keyIdSchema = RelationalDbDataSourceBackend.this.getKeyLoaderKeyIdSchema();
                this.keyIdTable = RelationalDbDataSourceBackend.this.getKeyLoaderKeyIdTable();
                this.keyIdColumn = RelationalDbDataSourceBackend.this.getKeyLoaderKeyIdColumn();
                this.keyIdJoinKey = RelationalDbDataSourceBackend.this.getKeyLoaderKeyIdJoinKey();
            }
            return super.build();
        }
    }
}

