/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.bp.commons;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendPropertySpec;
import org.protempa.backend.BackendPropertyType;
import org.protempa.backend.BackendPropertyValidator;
import org.protempa.backend.BackendProvider;
import org.protempa.backend.BackendSpec;
import org.protempa.backend.annotations.BackendInfo;
import org.protempa.backend.annotations.BackendProperty;
import org.protempa.bp.commons.InvalidBackendException;

final class BackendSpecFactory {
    private BackendSpecFactory() {
    }

    static <B extends Backend<?>> BackendSpec<B> newInstance(BackendProvider backendProvider, Class<B> backendCls) throws InvalidBackendException {
        BackendInfo backendAnnotation = backendCls.getAnnotation(BackendInfo.class);
        if (backendAnnotation == null) {
            throw new InvalidBackendException("No @BackendInfo annotation found");
        }
        Method[] methods = backendCls.getMethods();
        ArrayList<BackendProperty> backendPropertyAnnotations = new ArrayList<BackendProperty>();
        for (Method method : methods) {
            BackendProperty backendPropertyAnnotation = method.getAnnotation(BackendProperty.class);
            if (backendPropertyAnnotation == null) continue;
            backendPropertyAnnotations.add(backendPropertyAnnotation);
        }
        ArrayList<BackendPropertySpec> propSpecs = new ArrayList<BackendPropertySpec>(backendPropertyAnnotations.size());
        String baseName = backendAnnotation.propertiesBaseName();
        ResourceBundle bundle = null;
        if (!"".equals(baseName)) {
            try {
                bundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), backendCls.getClassLoader());
            }
            catch (MissingResourceException mre) {
                throw new AssertionError((Object)mre);
            }
        }
        for (Method method : methods) {
            String name;
            BackendProperty backendPropertyAnnotation = method.getAnnotation(BackendProperty.class);
            if (backendPropertyAnnotation == null) continue;
            Class validatorCls = backendPropertyAnnotation.validator();
            String propertyName = backendPropertyAnnotation.propertyName();
            if (propertyName.isEmpty()) {
                name = method.getName();
                name = name.substring(3);
            } else {
                name = propertyName;
            }
            char[] nameArr = name.toCharArray();
            nameArr[0] = Character.toLowerCase(nameArr[0]);
            name = String.valueOf(nameArr);
            String displayName = backendPropertyAnnotation.displayName();
            String description = backendPropertyAnnotation.description();
            Class<?> cls = method.getParameterTypes()[0];
            if (!BackendPropertyType.isAllowed(cls)) {
                throw new InvalidBackendException(MessageFormat.format("@BackendProperty cannot annotate method with parameter type {0}; allowed types are {1}", cls.getName(), StringUtils.join((Object[])BackendPropertyType.values(), (String)", ")));
            }
            try {
                propSpecs.add(new BackendPropertySpec(name, bundle != null ? bundle.getString(displayName) : displayName, bundle != null ? bundle.getString(description) : description, BackendPropertyType.fromCls(cls), backendPropertyAnnotation.required(), validatorCls != null ? (BackendPropertyValidator)validatorCls.newInstance() : null));
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        String displayName = backendAnnotation.displayName();
        if ("".equals(displayName)) {
            displayName = null;
        }
        return new BackendSpec(backendProvider, backendCls.getName(), displayName, propSpecs.toArray(new BackendPropertySpec[propSpecs.size()]));
    }
}

