/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.sql;

import javax.naming.NamingException;
import org.arp.javautil.sql.AbstractConnectionSpec;
import org.arp.javautil.sql.ConnectionSpec;
import org.arp.javautil.sql.DataSourceConnectionSpec;
import org.arp.javautil.sql.DriverManagerConnectionSpec;
import org.arp.javautil.sql.InvalidConnectionSpecArguments;

public enum DatabaseAPI {
    DRIVERMANAGER,
    DATASOURCE;


    public ConnectionSpec newConnectionSpecInstance(String databaseId, String username, String password) throws InvalidConnectionSpecArguments {
        return this.newConnectionSpecInstance(databaseId, username, password, true);
    }

    public ConnectionSpec newConnectionSpecInstance(String databaseId, String username, String password, boolean autoCommitEnabled) throws InvalidConnectionSpecArguments {
        AbstractConnectionSpec connectionSpec;
        switch (this) {
            case DRIVERMANAGER: {
                connectionSpec = new DriverManagerConnectionSpec(databaseId, username, password, autoCommitEnabled);
                break;
            }
            case DATASOURCE: {
                try {
                    connectionSpec = new DataSourceConnectionSpec(databaseId, username, password, autoCommitEnabled);
                    break;
                }
                catch (NamingException ex) {
                    throw new InvalidConnectionSpecArguments(ex);
                }
            }
            default: {
                throw new AssertionError((Object)"cannot be reached");
            }
        }
        return connectionSpec;
    }
}

