/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.DataType;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuildException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.UnknownPropositionDefinitionException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropDefConceptId;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.valueset.ValueSet;
import org.protempa.valueset.ValueSetElement;

class ValueSetConceptTreeBuilder
implements OntologyBuilder {
    private final String propertyName;
    private final String conceptCodePrefix;
    private final PropositionDefinition[] rootPropositionDefinitions;
    private final Metadata metadata;
    private final KnowledgeSourceCache cache;

    ValueSetConceptTreeBuilder(KnowledgeSourceCache cache, String[] propIds, String property, String conceptCodePrefix, Metadata metadata) throws KnowledgeSourceReadException, UnknownPropositionDefinitionException {
        assert (cache != null) : "cache cannot be null";
        ProtempaUtil.checkArray((Object[])propIds, (String)"propIds");
        assert (metadata != null) : "metadata cannot be null";
        this.cache = cache;
        this.propertyName = property;
        this.conceptCodePrefix = conceptCodePrefix;
        this.rootPropositionDefinitions = new PropositionDefinition[propIds.length];
        for (int i = 0; i < propIds.length; ++i) {
            this.rootPropositionDefinitions[i] = cache.get(propIds[i]);
            if (this.rootPropositionDefinitions[i] != null) continue;
            throw new UnknownPropositionDefinitionException(propIds[i]);
        }
        this.metadata = metadata;
    }

    @Override
    public void build(Concept concept) throws OntologyBuildException {
        try {
            for (PropositionDefinition propDefinition : this.rootPropositionDefinitions) {
                ValueSetElement[] vse;
                ConceptId rootConceptId = PropDefConceptId.getInstance(propDefinition.getId(), this.propertyName, this.metadata);
                Concept root = new Concept(rootConceptId, this.conceptCodePrefix, this.metadata);
                root.setSourceSystemCode(propDefinition.getSourceId().getStringRepresentation());
                root.setDataType(DataType.TEXT);
                root.setDisplayName(this.propertyName);
                if (concept != null) {
                    root.setAlreadyLoaded(concept.isAlreadyLoaded());
                }
                this.metadata.addToIdCache(root);
                PropertyDefinition propertyDef = propDefinition.propertyDefinition(this.propertyName);
                ValueSet valueSet = this.cache.getValueSet(propertyDef.getValueSetId());
                for (ValueSetElement e : vse = valueSet.getValueSetElements()) {
                    Concept vsEltConcept = new Concept(PropDefConceptId.getInstance(propDefinition.getId(), this.propertyName, e.getValue(), this.metadata), this.conceptCodePrefix, this.metadata);
                    vsEltConcept.setSourceSystemCode(valueSet.getSourceId().getStringRepresentation());
                    vsEltConcept.setInDataSource(true);
                    vsEltConcept.setDisplayName(e.getDisplayName());
                    vsEltConcept.setDataType(DataType.TEXT);
                    this.metadata.addToIdCache(vsEltConcept);
                    vsEltConcept.setAlreadyLoaded(root.isAlreadyLoaded());
                    root.add(vsEltConcept);
                }
                if (concept == null) continue;
                concept.add(root);
            }
        }
        catch (InvalidConceptCodeException ex) {
            throw new OntologyBuildException("Could not build value set concept tree", ex);
        }
    }
}

