/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.CMetadataXmlParser;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.backend.KnowledgeSourceBackendInitializationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class ValueMetadataSupport {
    private static final Logger LOGGER = Logger.getLogger(ValueMetadataSupport.class.getName());
    private final SAXParser saxParser;

    ValueMetadataSupport() throws KnowledgeSourceBackendInitializationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            this.saxParser = spf.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new KnowledgeSourceBackendInitializationException((Throwable)ex);
        }
    }

    XMLReader init(CMetadataXmlParser valueMetadataParser) throws KnowledgeSourceReadException {
        XMLReader xmlReader;
        try {
            xmlReader = this.saxParser.getXMLReader();
        }
        catch (SAXException ex) {
            throw new KnowledgeSourceReadException((Throwable)ex);
        }
        xmlReader.setContentHandler(valueMetadataParser);
        return xmlReader;
    }

    void parseAndFreeClob(XMLReader xmlReader, Clob clob) throws KnowledgeSourceReadException {
        if (clob != null) {
            try (Reader r = clob.getCharacterStream();){
                xmlReader.parse(new InputSource(r));
                clob.free();
                clob = null;
            }
            catch (IOException | SQLException | SAXException sqle) {
                throw new KnowledgeSourceReadException((Throwable)sqle);
            }
            finally {
                if (clob != null) {
                    try {
                        clob.free();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

