/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.log.Logging;
import org.protempa.DataSourceBackendSourceSystem;
import org.protempa.SourceSystem;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.MainResultProcessor;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.QueryResultsCacheException;
import org.protempa.backend.dsb.relationaldb.ResultCache;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.proposition.Constant;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.Value;

class ConstantResultProcessor
extends MainResultProcessor<Constant> {
    private static final int FLUSH_SIZE = 1000000;

    ConstantResultProcessor(ResultCache<Constant> results, EntitySpec entitySpec, String dataSourceBackendId) {
        super(results, entitySpec, dataSourceBackendId);
    }

    public void process(ResultSet resultSet) throws SQLException {
        int i;
        ResultCache<Constant> results = this.getResults();
        EntitySpec entitySpec = this.getEntitySpec();
        String entitySpecName = entitySpec.getName();
        String[] propIds = entitySpec.getPropositionIds();
        ColumnSpec codeSpec = entitySpec.getCodeSpec();
        if (codeSpec != null) {
            List<ColumnSpec> codeSpecL = codeSpec.asList();
            codeSpec = codeSpecL.get(codeSpecL.size() - 1);
        }
        Logger logger = SQLGenUtil.logger();
        PropertySpec[] propertySpecs = entitySpec.getPropertySpecs();
        Value[] propertyValues = new Value[propertySpecs.length];
        int count = 0;
        Object[] uniqueIds = new String[entitySpec.getUniqueIdSpecs().length];
        DataSourceBackendSourceSystem dsType = DataSourceBackendSourceSystem.getInstance((String)this.getDataSourceBackendId());
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int[] columnTypes = new int[resultSetMetaData.getColumnCount()];
        for (i = 0; i < columnTypes.length; ++i) {
            columnTypes[i] = resultSetMetaData.getColumnType(i + 1);
        }
        while (resultSet.next()) {
            String keyId;
            i = 1;
            if ((keyId = resultSet.getString(i++)) == null) {
                logger.warning("A keyId is null. Skipping record.");
                continue;
            }
            i = ConstantResultProcessor.readUniqueIds((String[])uniqueIds, resultSet, i);
            if (Arrays.contains((Object[])uniqueIds, null) && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Unique ids contain null ({0}). Skipping record.", StringUtils.join((Object[])uniqueIds, (String)", "));
                continue;
            }
            UniqueId uniqueId = this.generateUniqueId(entitySpecName, (String[])uniqueIds);
            String propId = null;
            if (!this.isCasePresent()) {
                String code;
                if (codeSpec == null) {
                    assert (propIds.length == 1) : "Don't know which proposition id to assign to";
                    propId = propIds[0];
                } else if ((propId = ConstantResultProcessor.sqlCodeToPropositionId(codeSpec, code = resultSet.getString(i++))) == null) {
                    continue;
                }
            } else {
                ++i;
            }
            i = this.extractPropertyValues(resultSet, i, propertyValues, columnTypes);
            if (this.isCasePresent()) {
                propId = resultSet.getString(i++);
            }
            Constant cp = new Constant(propId, uniqueId);
            for (int j = 0; j < propertySpecs.length; ++j) {
                PropertySpec propertySpec = propertySpecs[j];
                cp.setProperty(propertySpec.getName(), propertyValues[j]);
            }
            cp.setSourceSystem((SourceSystem)dsType);
            logger.log(Level.FINEST, "Created constant {0}", cp);
            results.add(keyId, cp);
            if (++count % 1000000 != 0) continue;
            try {
                results.flush(this);
            }
            catch (IOException ex) {
                throw new QueryResultsCacheException("Flushing primitive parameters to cache failed", ex);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            Logging.logCount((Logger)logger, (Level)Level.FINE, (int)count, (String)"Retrieved {0} record", (String)"Retrieved {0} records");
        }
        try {
            results.flush(this);
        }
        catch (IOException ex) {
            throw new QueryResultsCacheException("Flushing primitive parameters to cache failed", ex);
        }
        if (logger.isLoggable(Level.FINE)) {
            Logging.logCount((Logger)logger, (Level)Level.FINE, (int)count, (String)"Retrieved {0} record total", (String)"Retrieved {0} records total");
        }
    }
}

