/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.SelectClause;
import org.protempa.backend.dsb.relationaldb.StagedColumnSpec;
import org.protempa.backend.dsb.relationaldb.StagingSpec;
import org.protempa.backend.dsb.relationaldb.TableAliaser;
import org.protempa.backend.dsb.relationaldb.mappings.Mappings;

public final class StagingSelectClause
implements SelectClause {
    private final StagingSpec stagingSpec;
    private final EntitySpec entitySpec;
    private final TableAliaser referenceIndices;

    public StagingSelectClause(StagingSpec stagingSpec, EntitySpec entitySpec, TableAliaser referenceIndices) {
        this.stagingSpec = stagingSpec;
        this.entitySpec = entitySpec;
        this.referenceIndices = referenceIndices;
    }

    @Override
    public String generateClause() {
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        ArrayList<String> cols = new ArrayList<String>();
        for (StagedColumnSpec columnSpec : this.stagingSpec.getStagedColumns()) {
            StringBuilder colStr = new StringBuilder(this.referenceIndices.generateColumnReference(columnSpec.toColumnSpec()));
            if (null != columnSpec.getAsName() && !columnSpec.getAsName().isEmpty() && StagingSelectClause.isForEntitySpec(columnSpec, this.entitySpec)) {
                String asCol = colStr.toString() + " AS " + columnSpec.getAsName();
                cols.add(0, asCol);
            }
            cols.add(colStr.toString());
        }
        result.append(StringUtils.join(cols, (char)','));
        return result.toString();
    }

    private static boolean isForEntitySpec(StagedColumnSpec columnSpec, EntitySpec entitySpec) {
        for (String esName : columnSpec.getForEntitySpecs()) {
            if (!esName.equals(entitySpec.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCaseClause(Object[] sqlCodes, ColumnSpec columnSpec, Mappings mappings) {
        throw new UnsupportedOperationException();
    }
}

