/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.DataSourceReadException;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;

abstract class SQLExecutor {
    private final ConnectionSpec connectionSpec;
    private final String backendNameForMessages;
    private final Integer timeout;

    SQLExecutor(ConnectionSpec connectionSpec, String backendNameForMessages, Integer timeout) {
        this.backendNameForMessages = backendNameForMessages;
        this.connectionSpec = connectionSpec;
        this.timeout = timeout;
    }

    String getBackendNameForMessages() {
        return this.backendNameForMessages;
    }

    ConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    Integer getTimeout() {
        return this.timeout;
    }

    abstract void executeSelect(String var1, String var2, SQLGenResultProcessor var3) throws DataSourceReadException;

    protected void logQueryTimeout(Logger logger) {
        Level level = Level.FINER;
        if (logger.isLoggable(level)) {
            if (this.timeout != null) {
                logger.log(level, "Data source backend {0} has query timeout set to {1,number,integer} seconds", new Object[]{this.backendNameForMessages, this.timeout});
            } else {
                logger.log(level, "Query timeout is not set for data source backend {0}", new Object[]{this.backendNameForMessages});
            }
        }
    }
}

