/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.MetadataUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.ReferenceMap;

public final class TableUtil {
    private static final Map<Date, java.sql.Date> dateCache = new ReferenceMap();
    private static final Map<Date, Timestamp> timestampCache = new ReferenceMap();

    private TableUtil() {
    }

    static Logger logger() {
        return LazyLoggerHolder.instance;
    }

    public static String setStringAttribute(String attribute, int maxLength) {
        if (maxLength < 1) {
            throw new IllegalArgumentException("maxLength cannot be < 1");
        }
        if (attribute == null || attribute.length() == 0) {
            return "@";
        }
        if (attribute.length() > maxLength) {
            return attribute.substring(0, maxLength);
        }
        return attribute;
    }

    public static String setStringAttribute(String attribute) {
        if (attribute == null || attribute.length() == 0) {
            return "@";
        }
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date setDateAttribute(Date date) {
        java.sql.Date d;
        if (date == null) {
            return null;
        }
        Map<Date, java.sql.Date> map = dateCache;
        synchronized (map) {
            d = dateCache.get(date);
            if (d == null) {
                d = new java.sql.Date(date.getTime());
                dateCache.put(date, d);
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp setTimestampAttribute(Date date) {
        Timestamp ts;
        if (date == null) {
            return null;
        }
        Map<Date, Timestamp> map = timestampCache;
        synchronized (map) {
            ts = timestampCache.get(date);
            if (ts == null) {
                ts = new Timestamp(date.getTime());
                timestampCache.put(date, ts);
            }
        }
        return ts;
    }

    public static String setNullableStringAttribute(String attribute, int maxLength) {
        if (maxLength < 1) {
            throw new IllegalArgumentException("maxLength cannot be < 1");
        }
        if (attribute == null) {
            return null;
        }
        if (attribute.length() > maxLength) {
            return attribute.substring(0, maxLength);
        }
        return attribute;
    }

    private static class LazyLoggerHolder {
        private static Logger instance = Logger.getLogger(MetadataUtil.class.getPackage().getName());

        private LazyLoggerHolder() {
        }
    }
}

