/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata;

import edu.emory.cci.aiw.i2b2etl.dest.config.Settings;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.ConceptOperator;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.DataType;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuildException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropDefConceptId;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.Value;

class DemographicsAgeBuilder
implements OntologyBuilder {
    private static final String DEFAULT_AGE_PREFIX = "DEM|Age";
    private static final int[][] ageCategories = new int[][]{DemographicsAgeBuilder.ageGroup(0, 9), DemographicsAgeBuilder.ageGroup(10, 17), DemographicsAgeBuilder.ageGroup(18, 34), DemographicsAgeBuilder.ageGroup(35, 44), DemographicsAgeBuilder.ageGroup(45, 54), DemographicsAgeBuilder.ageGroup(55, 64), DemographicsAgeBuilder.ageGroup(65, 74), DemographicsAgeBuilder.ageGroup(75, 84), DemographicsAgeBuilder.ageGroup(85, 94), DemographicsAgeBuilder.ageGroup(95, 104), DemographicsAgeBuilder.ageGroup(105, 120)};
    private static final MessageFormat POSTGRESQL_AGE_FORMAT = new MessageFormat("now() - (365.25 * {0} || '' days'')::interval");
    private static final MessageFormat ORACLE_AGE_FORMAT = new MessageFormat("sysdate - (365.25 * {0})");
    private final Settings settings;
    private final Metadata metadata;

    DemographicsAgeBuilder(Metadata metadata) {
        assert (metadata != null) : "metadata cannot be null";
        this.metadata = metadata;
        this.settings = metadata.getSettings();
    }

    @Override
    public void build(Concept parent) throws OntologyBuildException {
        parent.add(this.buildAge(parent, "Age"));
    }

    private Concept buildAge(Concept parent, String displayName) throws OntologyBuildException {
        MessageFormat ageFormat;
        ConnectionSpec metaConnectionSpec;
        Concept age = this.metadata.newContainerConcept(displayName, "AIW|DEM|Age");
        age.setAlreadyLoaded(parent.isAlreadyLoaded());
        String ageConceptCodePrefix = this.settings.getAgeConceptCodePrefix();
        if (ageConceptCodePrefix == null) {
            ageConceptCodePrefix = DEFAULT_AGE_PREFIX;
        }
        if ((metaConnectionSpec = this.metadata.getMetaConnectionSpec()) != null) {
            try {
                switch (metaConnectionSpec.getDatabaseProduct()) {
                    case POSTGRESQL: {
                        ageFormat = POSTGRESQL_AGE_FORMAT;
                        break;
                    }
                    default: {
                        ageFormat = ORACLE_AGE_FORMAT;
                        break;
                    }
                }
            }
            catch (SQLException ex) {
                throw new OntologyBuildException(ex);
            }
        } else {
            ageFormat = ORACLE_AGE_FORMAT;
        }
        for (int i = 0; i < ageCategories.length; ++i) {
            int[] ages = ageCategories[i];
            String ageRangeDisplayName = String.valueOf(ages[0]) + '-' + String.valueOf(ages[ages.length - 1]) + " years old";
            PropDefConceptId ageRangeConceptId = PropDefConceptId.getInstance(null, null, (Value)NominalValue.getInstance((String)ageRangeDisplayName), this.metadata);
            Concept ageCategory = this.newQueryableConcept(ageRangeConceptId, ageConceptCodePrefix);
            ageCategory.setColumnName("birth_date");
            ageCategory.setDataType(DataType.NUMERIC);
            ageCategory.setDisplayName(ageRangeDisplayName);
            if (i == 0) {
                ageCategory.setOperator(ConceptOperator.GREATER_THAN);
                ageCategory.setDimCode(ageFormat.format(new Object[]{ages[ages.length - 1] + 1}));
            } else {
                ageCategory.setOperator(ConceptOperator.BETWEEN);
                ageCategory.setDimCode(ageFormat.format(new Object[]{ages[ages.length - 1] + 1}) + " AND " + ageFormat.format(new Object[]{ages[0]}));
            }
            ageCategory.setAlreadyLoaded(age.isAlreadyLoaded());
            age.add(ageCategory);
            for (int j = 0; j < ages.length; ++j) {
                PropDefConceptId conceptId = PropDefConceptId.getInstance(null, null, (Value)NumberValue.getInstance((long)ages[j]), this.metadata);
                Concept ageConcept = this.newQueryableConcept(conceptId, ageConceptCodePrefix);
                if (ages[j] == 1) {
                    ageConcept.setDisplayName(ages[j] + " year old");
                } else {
                    ageConcept.setDisplayName(ages[j] + " years old");
                }
                ageConcept.setDataType(DataType.NUMERIC);
                ageConcept.setColumnName("birth_date");
                ageConcept.setOperator(ConceptOperator.BETWEEN);
                ageConcept.setDimCode(ageFormat.format(new Object[]{ages[j] + 1}) + " AND " + ageFormat.format(new Object[]{ages[j]}));
                ageConcept.setAlreadyLoaded(ageCategory.isAlreadyLoaded());
                ageCategory.add(ageConcept);
            }
        }
        return age;
    }

    private Concept newQueryableConcept(PropDefConceptId conceptId, String conceptCodePrefix) throws OntologyBuildException {
        Concept concept = this.metadata.newConcept(conceptId, conceptCodePrefix, this.metadata.getSourceSystemCode());
        concept.setFactTableColumn("patient_num");
        concept.setTableName("patient_dimension");
        return concept;
    }

    private static int[] ageGroup(int minAge, int maxAge) {
        int[] result = new int[maxAge - minAge + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = minAge + i;
        }
        return result;
    }
}

