/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptHierarchyLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.MetaTableConceptHandler;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MetaTableConceptLoader
extends ConceptHierarchyLoader {
    private static final Logger LOGGER = Logger.getLogger(MetaTableConceptLoader.class.getName());
    private final MetaTableConceptHandler handler;

    public MetaTableConceptLoader(MetaTableConceptHandler handler) {
        this.handler = handler;
    }

    @Override
    protected void loadConcept(Concept concept) throws SQLException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Loading concept {0} into metadata table", concept.getFullName());
        }
        if (!concept.isAlreadyLoaded()) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Really loading concept {0} into metadata table", concept.getFullName());
            }
            this.handler.insert(concept);
        }
    }
}

