/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.ParameterSetter;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructor;
import edu.emory.cci.aiw.i2b2etl.ksb.ResultSetReader;
import edu.emory.cci.aiw.i2b2etl.ksb.TableAccessReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.arp.javautil.sql.InvalidConnectionSpecArguments;
import org.protempa.KnowledgeSourceReadException;

public class QueryExecutor
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(QueryExecutor.class.getName());
    private static final ParameterSetter EMPTY_PARAM_SETTER = new ParameterSetter(){

        @Override
        public int set(PreparedStatement stmt, int j) throws SQLException {
            return j;
        }
    };
    private final Connection connection;
    private String sql;
    private PreparedStatement preparedStatement;
    private String[] ontTables;
    private final QueryConstructor queryConstructor;
    private TableAccessReader ontTableReader;
    private String[] tables;

    public QueryExecutor(Connection connection, QueryConstructor queryConstructor, TableAccessReader ontTableReader) {
        this.connection = connection;
        this.queryConstructor = queryConstructor;
        this.ontTableReader = ontTableReader;
    }

    public QueryExecutor(Connection connection, QueryConstructor queryConstructor, String ... tables) {
        this.connection = connection;
        this.queryConstructor = queryConstructor;
        this.tables = tables;
    }

    public <E> E execute(ResultSetReader<E> resultSetReader) throws KnowledgeSourceReadException {
        return this.execute(EMPTY_PARAM_SETTER, resultSetReader);
    }

    public <E> E execute(final String bindArgument, ResultSetReader<E> resultSetReader) throws KnowledgeSourceReadException {
        return this.execute(new ParameterSetter(){

            @Override
            public int set(PreparedStatement stmt, int j) throws SQLException {
                stmt.setString(j++, bindArgument);
                return j;
            }
        }, resultSetReader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E> E execute(ParameterSetter paramSetter, ResultSetReader<E> resultSetReader) throws KnowledgeSourceReadException {
        try {
            this.prepare();
            if (this.preparedStatement == null) {
                return resultSetReader.read(null);
            }
            int j = 1;
            int n = this.ontTables.length;
            for (int i = 0; i < n; ++i) {
                j = paramSetter.set(this.preparedStatement, j);
            }
            try (ResultSet rs = this.preparedStatement.executeQuery();){
                E e = resultSetReader.read(rs);
                return e;
            }
        }
        catch (SQLException ex) {
            throw new KnowledgeSourceReadException((Throwable)ex);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void close() throws KnowledgeSourceReadException {
        if (this.preparedStatement != null) {
            try {
                this.preparedStatement.close();
            }
            catch (SQLException ex) {
                throw new KnowledgeSourceReadException((Throwable)ex);
            }
            this.preparedStatement = null;
        }
    }

    public void prepare() throws KnowledgeSourceReadException {
        if (this.preparedStatement == null) {
            try {
                this.openConnection();
                this.readOntologyTables();
                StringBuilder sql = new StringBuilder();
                if (this.ontTables.length > 0) {
                    if (this.ontTables.length > 1) {
                        sql.append('(');
                    }
                    int n = this.ontTables.length;
                    for (int i = 0; i < n; ++i) {
                        String table = this.ontTables[i];
                        if (i > 0) {
                            sql.append(") UNION ALL (");
                        }
                        this.queryConstructor.appendStatement(sql, table);
                    }
                    if (this.ontTables.length > 1) {
                        sql.append(')');
                    }
                    this.sql = sql.toString();
                    LOGGER.log(Level.FINE, "Preparing query {0}", this.sql);
                    this.preparedStatement = this.connection.prepareStatement(this.sql);
                    this.preparedStatement.setFetchSize(1000);
                }
            }
            catch (SQLException | InvalidConnectionSpecArguments ex) {
                throw new KnowledgeSourceReadException(ex);
            }
        }
    }

    private Connection openConnection() throws InvalidConnectionSpecArguments, SQLException {
        return this.connection;
    }

    private void readOntologyTables() throws KnowledgeSourceReadException {
        this.ontTables = this.ontTableReader != null ? this.ontTableReader.read(this.connection) : (this.tables != null ? this.tables : ArrayUtils.EMPTY_STRING_ARRAY);
    }
}

