/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastOutputStream
extends OutputStream {
    public static final int DEFAULT_INIT_SIZE = 100;
    public static final int DEFAULT_BUMP_SIZE = 0;
    private int len;
    private int bumpLen;
    private byte[] buf;
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    public FastOutputStream() {
        this.initBuffer(100, 0);
    }

    public FastOutputStream(int initialSize) {
        this.initBuffer(initialSize, 0);
    }

    public FastOutputStream(int initialSize, int bumpSize) {
        this.initBuffer(initialSize, bumpSize);
    }

    public FastOutputStream(byte[] buffer) {
        this.buf = buffer;
        this.bumpLen = 0;
    }

    public FastOutputStream(byte[] buffer, int bumpSize) {
        this.buf = buffer;
        this.bumpLen = bumpSize;
    }

    private void initBuffer(int bufferSize, int bumplength) {
        this.buf = new byte[bufferSize];
        this.bumpLen = bumplength;
    }

    public int size() {
        return this.len;
    }

    public void reset() {
        this.len = 0;
    }

    public void write(int b) {
        this.writeFast(b);
    }

    public void write(byte[] fromBuf) {
        this.writeFast(fromBuf);
    }

    public void write(byte[] fromBuf, int offset, int length) {
        this.writeFast(fromBuf, offset, length);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.len);
    }

    public String toString() {
        return new String(this.buf, 0, this.len);
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.len, encoding);
    }

    public byte[] toByteArray() {
        if (this.len == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] toBuf = new byte[this.len];
        System.arraycopy(this.buf, 0, toBuf, 0, this.len);
        return toBuf;
    }

    public final void writeFast(int b) {
        if (this.len + 1 > this.buf.length) {
            this.bump(1);
        }
        this.buf[this.len++] = (byte)b;
    }

    public final void writeFast(byte[] fromBuf) {
        int needed = this.len + fromBuf.length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        System.arraycopy(fromBuf, 0, this.buf, this.len, fromBuf.length);
        this.len += fromBuf.length;
    }

    public final void writeFast(byte[] fromBuf, int offset, int length) {
        int needed = this.len + length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        System.arraycopy(fromBuf, offset, this.buf, this.len, length);
        this.len += length;
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return 0;
    }

    public int getBufferLength() {
        return this.len;
    }

    public void makeSpace(int sizeNeeded) {
        int needed = this.len + sizeNeeded - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
    }

    public void addSize(int sizeAdded) {
        this.len += sizeAdded;
    }

    private void bump(int needed) {
        int bump = this.bumpLen > 0 ? this.bumpLen : this.buf.length;
        byte[] toBuf = new byte[this.buf.length + needed + bump];
        System.arraycopy(this.buf, 0, toBuf, 0, this.len);
        this.buf = toBuf;
    }
}

