/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.util;

import edu.emory.cci.aiw.i2b2etl.util.SqlRunner;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RecordHandler<E>
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(RecordHandler.class.getName());
    private boolean init;
    private int counter = 0;
    private volatile PreparedStatement ps;
    private final String statement;
    private Connection cn;
    private final Timestamp importTimestamp;
    private final boolean commit;
    private final SqlRunner executor;

    public RecordHandler(Connection connection, String statement) throws SQLException {
        this(connection, statement, true);
    }

    public RecordHandler(Connection connection, String statement, boolean commit) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("statement cannot be null");
        }
        this.cn = connection;
        this.statement = statement;
        this.importTimestamp = new Timestamp(System.currentTimeMillis());
        this.commit = commit;
        this.ps = this.cn.prepareStatement(this.statement);
        this.executor = new SqlRunner(this.ps, this.commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(E record) throws SQLException {
        SQLException exceptionThrown;
        if (!this.init) {
            this.executor.start();
            this.init = true;
        }
        if ((exceptionThrown = this.executor.getException()) != null) {
            throw exceptionThrown;
        }
        if (record != null) {
            try {
                SqlRunner sqlRunner = this.executor;
                synchronized (sqlRunner) {
                    this.setParameters(this.ps, record);
                    this.ps.addBatch();
                    ++this.counter;
                    this.executor.incrementCommitCounter();
                    if (this.counter >= this.executor.getBatchSize()) {
                        this.executor.notify();
                        this.counter = 0;
                    }
                }
            }
            catch (SQLException e) {
                if (this.ps != null) {
                    try {
                        this.ps.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
    }

    protected abstract void setParameters(PreparedStatement var1, E var2) throws SQLException;

    protected Connection getConnection() {
        return this.cn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void close() throws SQLException {
        exceptionThrown = this.executor.getException();
        try {
            if (exceptionThrown != null) {
                throw exceptionThrown;
            }
        }
        finally {
            if (this.ps != null) {
                try {
                    var2_2 = this.executor;
                    synchronized (var2_2) {
                        this.executor.requestStop();
                        this.executor.notify();
                    }
                    this.executor.join();
                    if (this.counter > 0) {
                        this.ps.executeBatch();
                    }
                    if (this.commit && this.executor.getCommitCounter() > 0) {
                        this.cn.commit();
                    }
                    this.ps.close();
                    this.ps = null;
                    ** if (this.ps == null) goto lbl-1000
                }
                catch (SQLException ex) {
                    this.rollback(ex);
                    if (exceptionThrown == null) {
                        throw ex;
                    }
                    exceptionThrown.addSuppressed(ex);
                    ** if (this.ps == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.ps.close();
                        }
                        catch (SQLException ex) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (InterruptedException ex) {
                    this.rollback(ex);
                    RecordHandler.LOGGER.log(Level.FINE, "Close was interrupted: {0}", ex);
                    ** if (this.ps == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.ps.close();
                        }
                        catch (SQLException var2_7) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    {
                        catch (Throwable var4_9) {
                            if (this.ps != null) {
                                try {
                                    this.ps.close();
                                }
                                catch (SQLException var5_10) {}
                            }
                            throw var4_9;
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        this.ps.close();
                    }
                    catch (SQLException var2_3) {}
                }
lbl-1000:
                // 2 sources

                {
                }
            }
        }
    }

    protected Timestamp importTimestamp() {
        return this.importTimestamp;
    }

    private void rollback(Throwable throwable) {
        if (this.commit) {
            try {
                this.cn.rollback();
            }
            catch (SQLException ignore) {
                throwable.addSuppressed(ignore);
            }
        }
    }
}

