/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.TimeZone;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.protempa.ContextDefinition;
import org.protempa.ContextOffset;
import org.protempa.DerivationsBuilder;
import org.protempa.JBossRulesDerivedLocalUniqueIdValuesProvider;
import org.protempa.proposition.Context;
import org.protempa.proposition.ProviderBasedUniqueIdFactory;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Unit;

class ContextDefinitionInducedByConsequence
implements Consequence {
    private final DerivationsBuilder derivationsBuilder;
    private final ContextDefinition def;
    private transient IntervalFactory intervalFactory;
    private final long earliestTime;
    private final long latestTime;

    ContextDefinitionInducedByConsequence(ContextDefinition def, DerivationsBuilder derivationsBuilder) {
        assert (def != null) : "def cannot be null";
        assert (derivationsBuilder != null) : "derivationsBuilder cannot be null";
        this.def = def;
        this.derivationsBuilder = derivationsBuilder;
        this.intervalFactory = new IntervalFactory();
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.set(cal.getMinimum(1), cal.getMinimum(2), cal.getMinimum(5), cal.getMinimum(10), cal.getMinimum(12), cal.getMinimum(13));
        this.earliestTime = cal.getTimeInMillis();
        this.latestTime = Long.MAX_VALUE;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.intervalFactory = new IntervalFactory();
    }

    public void evaluate(KnowledgeHelper kh, WorkingMemory wm) throws Exception {
        Granularity finishGran;
        Granularity startGran;
        TemporalProposition prop = (TemporalProposition)wm.getObject((FactHandle)kh.getTuple().get(0));
        JBossRulesDerivedLocalUniqueIdValuesProvider provider = new JBossRulesDerivedLocalUniqueIdValuesProvider(wm, this.def.getPropositionId());
        ProviderBasedUniqueIdFactory factory = new ProviderBasedUniqueIdFactory(provider);
        Context context = new Context(this.def.getPropositionId(), factory.getInstance());
        ContextOffset temporalOffset = this.def.getOffset();
        Interval oldInterval = prop.getInterval();
        Long minStart = temporalOffset.getStartIntervalSide() == Interval.Side.START ? prop.getInterval().getMinStart() : prop.getInterval().getMinFinish();
        Long maxStart = temporalOffset.getStartIntervalSide() == Interval.Side.START ? prop.getInterval().getMaxStart() : prop.getInterval().getMaxFinish();
        Integer startOffset = temporalOffset.getStartOffset();
        if (startOffset != null) {
            Unit startOffsetUnits = temporalOffset.getStartOffsetUnits();
            if (startOffsetUnits != null) {
                minStart = startOffsetUnits.addToPosition(minStart, startOffset);
                maxStart = startOffsetUnits.addToPosition(maxStart, startOffset);
            } else {
                minStart = minStart + (long)startOffset.intValue();
                maxStart = maxStart + (long)startOffset.intValue();
            }
            startGran = prop.getInterval().getStartGranularity();
        } else {
            minStart = this.earliestTime;
            maxStart = this.earliestTime;
            startGran = null;
        }
        Long minFinish = temporalOffset.getFinishIntervalSide() == Interval.Side.START ? oldInterval.getMinStart() : oldInterval.getMinFinish();
        Long maxFinish = temporalOffset.getFinishIntervalSide() == Interval.Side.START ? oldInterval.getMaxStart() : oldInterval.getMaxFinish();
        Integer finishOffset = temporalOffset.getFinishOffset();
        if (finishOffset != null) {
            Unit finishOffsetUnits = temporalOffset.getFinishOffsetUnits();
            if (finishOffsetUnits != null) {
                minFinish = finishOffsetUnits.addToPosition(minFinish, finishOffset);
                maxFinish = finishOffsetUnits.addToPosition(maxFinish, finishOffset);
            } else {
                minFinish = minFinish + (long)finishOffset.intValue();
                maxFinish = maxFinish + (long)finishOffset.intValue();
            }
            finishGran = oldInterval.getFinishGranularity();
        } else {
            minFinish = this.latestTime;
            maxFinish = this.latestTime;
            finishGran = null;
        }
        context.setInterval(this.intervalFactory.getInstance(minStart, maxStart, startGran, minFinish, maxFinish, finishGran));
        kh.getWorkingMemory().insert((Object)context);
        this.derivationsBuilder.propositionAsserted(prop, context);
    }
}

