/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Collection;
import java.util.HashMap;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.valueset.ValueSet;

public final class KnowledgeSourceCacheFactory {
    public KnowledgeSourceCache getInstance(KnowledgeSource ks, Collection<PropositionDefinition> cache, boolean collectValueSets) throws KnowledgeSourceReadException {
        HashMap<String, ValueSet> vsCache;
        HashMap<String, PropositionDefinition> propDefCache = new HashMap<String, PropositionDefinition>();
        for (PropositionDefinition pd : cache) {
            propDefCache.put(pd.getId(), pd);
        }
        if (collectValueSets) {
            vsCache = new HashMap<String, ValueSet>();
            for (PropositionDefinition propDef : cache) {
                for (PropertyDefinition pd : propDef.getPropertyDefinitions()) {
                    String valueSetId = pd.getValueSetId();
                    if (valueSetId == null) continue;
                    vsCache.put(valueSetId, ks.readValueSet(valueSetId));
                }
            }
        } else {
            vsCache = null;
        }
        return new KnowledgeSourceCache(propDefCache, vsCache);
    }
}

