/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.datastore;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.datastore.BdbPersistentStoreFactory;
import org.arp.javautil.datastore.DataStore;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.protempa.datastore.AbstractDataStoreCreator;
import org.protempa.datastore.DataStoreUtil;
import org.protempa.datastore.DroolsWorkingMemoryStore;

public final class WorkingMemoryStoreCreator
extends AbstractDataStoreCreator<String, WorkingMemory> {
    public static final String DATABASE_NAME = "WorkingMemoryStore";
    private final RuleBase ruleBase;
    private final BdbPersistentStoreFactory storeFactory;
    private int index;

    public WorkingMemoryStoreCreator(RuleBase ruleBase) {
        this(ruleBase, null);
    }

    public WorkingMemoryStoreCreator(RuleBase ruleBase, String environmentName) {
        super(environmentName);
        this.ruleBase = ruleBase;
        this.storeFactory = environmentName != null ? new BdbPersistentStoreFactory(environmentName) : null;
    }

    public static WorkingMemoryStoreCreator getInstance(RuleBase ruleBase) {
        return new WorkingMemoryStoreCreator(ruleBase);
    }

    @Override
    public DataStore<String, WorkingMemory> getPersistentStore() {
        if (this.storeFactory == null) {
            throw new IllegalStateException("null environmentName; cannot get a persistent store");
        }
        Logger logger = DataStoreUtil.logger();
        logger.log(Level.FINEST, "Persistent store {0} has not been accessed during this run or does not exist: attempting to get it from the underlying store", this.getEnvironmentName());
        DroolsWorkingMemoryStore store = new DroolsWorkingMemoryStore(this.storeFactory, this.nextDatabaseName(), this.ruleBase);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String nextDatabaseName() {
        WorkingMemoryStoreCreator workingMemoryStoreCreator = this;
        synchronized (workingMemoryStoreCreator) {
            return DATABASE_NAME + this.index++;
        }
    }
}

