/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.interval;

import java.io.Serializable;
import java.util.Arrays;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.Unit;

public final class Relation
implements Serializable {
    private static final long serialVersionUID = -7813328179876098366L;
    private final Integer[] intValues;
    private final Unit[] units;
    public static final Relation BEFORE = new Relation(null, null, null, null, null, null, null, null, 1, null, null, null, null, null, null, null);
    public static final Relation AFTER = BEFORE.inverse();
    public static final Relation OVERLAPS = new Relation(1, null, null, null, null, null, null, null, null, null, -1, null, 1, null, null, null);
    public static final Relation OVERLAPPED_BY = OVERLAPS.inverse();
    public static final Relation MEETS = new Relation(null, null, null, null, null, null, null, null, 0, null, 0, null, null, null, null, null);
    public static final Relation MET_BY = MEETS.inverse();
    public static final Relation EQUALS = new Relation(0, null, 0, null, null, null, null, null, null, null, null, null, 0, null, 0, null);
    public static final Relation CONTAINS = new Relation(1, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, null);
    public static final Relation CONTAINS_OR_EQUALS = new Relation(0, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, null);
    public static final Relation DURING = CONTAINS.inverse();
    public static final Relation STARTS = new Relation(0, null, 0, null, null, null, null, null, null, null, null, null, 0, null, -1, null);
    public static final Relation STARTED_BY = STARTS.inverse();
    public static final Relation FINISHES = new Relation(1, null, null, null, null, null, null, null, null, null, null, null, 0, null, 0, null);
    public static final Relation FINISHED_BY = STARTS.inverse();

    public Relation() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Relation(Integer minDistanceBetweenStarts, Unit minDistanceBetweenStartsUnits, Integer maxDistanceBetweenStarts, Unit maxDistanceBetweenStartsUnits, Integer minSpan, Unit minSpanUnits, Integer maxSpan, Unit maxSpanUnits, Integer minDistanceBetween, Unit minDistanceBetweenUnits, Integer maxDistanceBetween, Unit maxDistanceBetweenUnits, Integer minDistanceBetweenFinishes, Unit minDistanceBetweenFinishesUnits, Integer maxDistanceBetweenFinishes, Unit maxDistanceBetweenFinishesUnits) {
        this(new Integer[]{minDistanceBetweenStarts, maxDistanceBetweenStarts, minSpan, maxSpan, minDistanceBetween, maxDistanceBetween, minDistanceBetweenFinishes, maxDistanceBetweenFinishes}, new Unit[]{minDistanceBetweenStartsUnits, maxDistanceBetweenStartsUnits, minSpanUnits, maxSpanUnits, minDistanceBetweenUnits, maxDistanceBetweenUnits, minDistanceBetweenFinishesUnits, maxDistanceBetweenFinishesUnits});
    }

    private Relation(Integer[] intValues, Unit[] units) {
        this.intValues = intValues;
        this.units = units;
    }

    public Relation inverse() {
        return new Relation(new Integer[]{this.intValues[1], this.intValues[0], this.intValues[5], this.intValues[4], this.intValues[3], this.intValues[2], this.intValues[7], this.intValues[6]}, new Unit[]{this.units[1], this.units[0], this.units[5], this.units[4], this.units[3], this.units[2], this.units[7], this.units[6]});
    }

    public Integer getMinDistanceBetweenStarts() {
        return this.intValues[0];
    }

    public Unit getMinDistanceBetweenStartsUnits() {
        return this.units[0];
    }

    public Integer getMaxDistanceBetweenStarts() {
        return this.intValues[1];
    }

    public Unit getMaxDistanceBetweenStartsUnits() {
        return this.units[1];
    }

    public Integer getMinSpan() {
        return this.intValues[2];
    }

    public Unit getMinSpanUnits() {
        return this.units[2];
    }

    public Integer getMaxSpan() {
        return this.intValues[3];
    }

    public Unit getMaxSpanUnits() {
        return this.units[3];
    }

    public Integer getMinDistanceBetween() {
        return this.intValues[4];
    }

    public Unit getMinDistanceBetweenUnits() {
        return this.units[4];
    }

    public Integer getMaxDistanceBetween() {
        return this.intValues[5];
    }

    public Unit getMaxDistanceBetweenUnits() {
        return this.units[5];
    }

    public Integer getMinDistanceBetweenFinishes() {
        return this.intValues[6];
    }

    public Unit getMinDistanceBetweenFinishesUnits() {
        return this.units[6];
    }

    public Integer getMaxDistanceBetweenFinishes() {
        return this.intValues[7];
    }

    public Unit getMaxDistanceBetweenFinishesUnits() {
        return this.units[7];
    }

    public boolean hasRelation(Interval interval1, Interval interval2) {
        if (interval1 == null || interval2 == null) {
            return false;
        }
        Long minStart1 = interval1.getMinimumStart();
        Long maxStart1 = interval1.getMaximumStart();
        Long minFinish1 = interval1.getMinimumFinish();
        Long maxFinish1 = interval1.getMaximumFinish();
        Long minStart2 = interval2.getMinimumStart();
        Long maxStart2 = interval2.getMaximumStart();
        Long minFinish2 = interval2.getMinimumFinish();
        Long maxFinish2 = interval2.getMaximumFinish();
        return this.evenHasRelationCheck(0, minStart1, minStart2) && this.oddHasRelationCheck(1, maxStart1, maxStart2) && this.evenHasRelationCheck(2, minStart1, minFinish2) && this.oddHasRelationCheck(3, maxStart1, maxFinish2) && this.evenHasRelationCheck(4, minFinish1, minStart2) && this.oddHasRelationCheck(5, maxFinish1, maxStart2) && this.evenHasRelationCheck(6, minFinish1, minFinish2) && this.oddHasRelationCheck(7, maxFinish1, maxFinish2);
    }

    private boolean evenHasRelationCheck(int i, Long lhs, Long rhs) {
        if (this.units[i] != null && lhs != null && rhs != null && this.intValues[i] != null) {
            long rhsl;
            long lhsl = lhs;
            if (lhsl <= (rhsl = rhs.longValue())) {
                return Relation.isLessThanOrEqualToDuration(this.units[i], lhsl, rhsl, this.intValues[i]);
            }
            return Relation.isGreaterThanOrEqualToDuration(this.units[i], rhsl, lhsl, -this.intValues[i].intValue());
        }
        if (lhs != null && rhs != null && this.intValues[i] != null) {
            return lhs + (long)this.intValues[i].intValue() <= rhs;
        }
        return (rhs != null || lhs == null) && this.intValues[i] == null;
    }

    private boolean oddHasRelationCheck(int i, Long lhs, Long rhs) {
        if (this.units[i] != null && lhs != null && rhs != null && this.intValues[i] != null) {
            return Relation.isGreaterThanOrEqualToDuration(this.units[i], lhs, rhs, this.intValues[i]);
        }
        if (lhs != null && rhs != null && this.intValues[i] != null) {
            return lhs + (long)this.intValues[i].intValue() >= rhs;
        }
        return (lhs != null || rhs == null) && this.intValues[i] == null;
    }

    static boolean isGreaterThanOrEqualToDuration(Unit unit, long position1, long position2, int duration) {
        return unit.addToPosition(position1, duration + 1) - 1L >= position2;
    }

    static boolean isLessThanOrEqualToDuration(Unit unit, long position1, long position2, int duration) {
        return unit.addToPosition(position1, duration) <= position2;
    }

    public String toString() {
        return "RELATION: " + Arrays.asList(this.intValues) + "; " + Arrays.asList(this.units);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.intValues);
        result = 31 * result + Arrays.hashCode(this.units);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Relation other = (Relation)obj;
        if (!Arrays.equals((Object[])this.intValues, (Object[])other.intValues)) {
            return false;
        }
        return Arrays.equals(this.units, other.units);
    }
}

