/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.InequalityNumberValueBuilder;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.NumericalValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueList;
import org.protempa.proposition.value.ValueType;
import org.protempa.proposition.value.ValueVisitor;

public final class InequalityNumberValue
implements NumericalValue,
Serializable {
    private static final long serialVersionUID = 1485092589217545627L;
    private NumberValue val;
    private ValueComparator comp;
    private volatile transient int hashCode;

    public static InequalityNumberValue parse(String str) {
        return (InequalityNumberValue)ValueType.INEQUALITYNUMBERVALUE.parse(str);
    }

    public InequalityNumberValue(ValueComparator comparator, double val) {
        this(comparator, BigDecimal.valueOf(val));
    }

    public InequalityNumberValue(ValueComparator comparator, BigDecimal val) {
        this.init(comparator, val);
    }

    private void init(ValueComparator comparator, BigDecimal val) {
        this.val = val != null ? NumberValue.getInstance(val) : NumberValue.getInstance(0L);
        this.comp = comparator == null ? ValueComparator.EQUAL_TO : comparator;
    }

    @Override
    public InequalityNumberValue replace() {
        return this;
    }

    @Override
    public Number getNumber() {
        return this.val.getNumber();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.val.getBigDecimal();
    }

    @Override
    public double doubleValue() {
        if (this.comp == ValueComparator.EQUAL_TO) {
            return this.val.doubleValue();
        }
        if (this.comp == ValueComparator.LESS_THAN) {
            return this.val.doubleValue() - Double.MIN_VALUE;
        }
        return this.val.doubleValue() + Double.MIN_VALUE;
    }

    public ValueComparator getInequality() {
        return this.comp;
    }

    @Override
    public String getFormatted() {
        return this.comp.getComparatorString() + " " + this.val.getFormatted();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public ValueComparator getComparator() {
        return this.comp;
    }

    @Override
    public ValueType getType() {
        return ValueType.INEQUALITYNUMBERVALUE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InequalityNumberValue i = (InequalityNumberValue)obj;
        return (this.val == i.val || this.val.equals(i.val)) && this.comp == i.comp;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.val.hashCode();
            this.hashCode = result = 37 * result + this.comp.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public ValueComparator compare(Value d2) {
        if (d2 == null) {
            return ValueComparator.NOT_EQUAL_TO;
        }
        switch (d2.getType()) {
            case NUMBERVALUE: {
                NumberValue otherVal = (NumberValue)d2;
                int valComp = this.val.compareTo(otherVal);
                switch (this.comp) {
                    case EQUAL_TO: {
                        return valComp > 0 ? ValueComparator.GREATER_THAN : (valComp < 0 ? ValueComparator.LESS_THAN : ValueComparator.EQUAL_TO);
                    }
                    case LESS_THAN: {
                        return valComp <= 0 ? ValueComparator.LESS_THAN : ValueComparator.UNKNOWN;
                    }
                }
                return valComp >= 0 ? ValueComparator.GREATER_THAN : ValueComparator.UNKNOWN;
            }
            case INEQUALITYNUMBERVALUE: {
                InequalityNumberValue other = (InequalityNumberValue)d2;
                ValueComparator d2Comp = other.comp;
                int valComp2 = this.val.compareTo(other.val);
                if (this.comp == d2Comp) {
                    if (this.comp == ValueComparator.EQUAL_TO) {
                        return valComp2 > 0 ? ValueComparator.GREATER_THAN : (valComp2 < 0 ? ValueComparator.LESS_THAN : ValueComparator.EQUAL_TO);
                    }
                    return ValueComparator.UNKNOWN;
                }
                if (this.comp == ValueComparator.GREATER_THAN && d2Comp == ValueComparator.LESS_THAN) {
                    if (valComp2 >= 0) {
                        return ValueComparator.GREATER_THAN;
                    }
                    return ValueComparator.UNKNOWN;
                }
                if (valComp2 <= 0) {
                    return ValueComparator.LESS_THAN;
                }
                return ValueComparator.UNKNOWN;
            }
            case VALUELIST: {
                ValueList vl = (ValueList)d2;
                return vl.contains(this) ? ValueComparator.IN : ValueComparator.NOT_IN;
            }
        }
        return ValueComparator.NOT_EQUAL_TO;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        if (valueVisitor == null) {
            throw new IllegalArgumentException("valueVisitor cannot be null");
        }
        valueVisitor.visit(this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.val.getBigDecimal());
        s.writeObject((Object)this.comp);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        BigDecimal tmpVal = (BigDecimal)s.readObject();
        ValueComparator tmpComp = (ValueComparator)((Object)s.readObject());
        this.init(tmpComp, tmpVal);
    }

    @Override
    public NumberValue getNumberValue() {
        return this.val;
    }

    @Override
    public InequalityNumberValueBuilder asBuilder() {
        return new InequalityNumberValueBuilder(this);
    }
}

