/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.impl;

import java.io.Serializable;
import org.drools.ruleflow.core.Connection;
import org.drools.ruleflow.core.Node;
import org.drools.ruleflow.core.impl.NodeImpl;

public class ConnectionImpl
implements Connection,
Serializable {
    private static final long serialVersionUID = 400L;
    private int type;
    private NodeImpl from;
    private NodeImpl to;

    private ConnectionImpl() {
    }

    public ConnectionImpl(Node from, Node to, int type) {
        if (from == null) {
            throw new IllegalArgumentException("From node is null!");
        }
        if (to == null) {
            throw new IllegalArgumentException("To node is null!");
        }
        if (from.equals(to)) {
            throw new IllegalArgumentException("To and from nodes are the same!");
        }
        this.from = (NodeImpl)from;
        this.to = (NodeImpl)to;
        this.type = type;
        this.from.addOutgoingConnection(this);
        this.to.addIncomingConnection(this);
    }

    public synchronized void terminate() {
        this.from.removeOutgoingConnection(this);
        this.to.removeIncomingConnection(this);
        this.type = 0;
        this.from = null;
        this.to = null;
    }

    public Node getFrom() {
        return this.from;
    }

    public Node getTo() {
        return this.to;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Connection ");
        sb.append(this.getFrom());
        sb.append(" - ");
        sb.append(this.getTo());
        sb.append(" [type=");
        sb.append(this.getType());
        sb.append("]");
        return sb.toString();
    }
}

