/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.arp.javautil.string.StringUtil;

public final class DelimitedWriter
implements Closeable,
Flushable {
    private final char delimiter;
    private final Writer writer;
    private boolean firstColumn;
    private final String lineSeparator;

    public DelimitedWriter(char delimiter, Writer writer) {
        this(delimiter, writer, null);
    }

    public DelimitedWriter(char delimiter, Writer writer, String lineSeparator) {
        this.delimiter = delimiter;
        this.writer = writer;
        this.firstColumn = true;
        this.lineSeparator = lineSeparator != null ? lineSeparator : IOUtils.LINE_SEPARATOR;
    }

    public void write(String column) throws IOException {
        if (!this.firstColumn) {
            this.writer.write(this.delimiter);
        }
        StringUtil.escapeAndWriteDelimitedColumn(column, this.delimiter, this.writer);
        this.firstColumn = false;
    }

    public void newLine() throws IOException {
        this.writer.write(this.lineSeparator);
        this.firstColumn = true;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }
}

