/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.protempa.DataSourceBackendSourceSystem;
import org.protempa.DataStreamingEventIterator;
import org.protempa.SourceSystem;
import org.protempa.UniqueIdPair;
import org.protempa.backend.dsb.relationaldb.AbstractResultProcessor;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EmptyDataStreamingEventIterator;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.InboundReferenceResultSetIterator;
import org.protempa.backend.dsb.relationaldb.JDBCPositionFormat;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.PropositionResultSetIterator;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.backend.dsb.relationaldb.StreamingMainResultProcessor;
import org.protempa.proposition.Event;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Value;

class EventStreamingResultProcessor
extends StreamingMainResultProcessor<Event> {
    private static final DataStreamingEventIterator<UniqueIdPair> EMPTY_UNIQUE_ID_PAIR_ITR = new EmptyDataStreamingEventIterator<UniqueIdPair>();
    private static final DataStreamingEventIterator<Event> EMPTY_EVENT_ITR = new EmptyDataStreamingEventIterator<Event>();
    private EventIterator itr;
    private final Set<String> queryPropIds;

    EventStreamingResultProcessor(EntitySpec entitySpec, LinkedHashMap<String, ReferenceSpec> inboundRefSpecs, Map<String, ReferenceSpec> bidirectionalRefSpecs, String dataSourceBackendId, Set<String> propIds) {
        super(entitySpec, inboundRefSpecs, bidirectionalRefSpecs, dataSourceBackendId);
        assert (propIds != null) : "propIds cannot be null";
        this.queryPropIds = propIds;
    }

    public void process(ResultSet resultSet) throws SQLException {
        EntitySpec entitySpec = this.getEntitySpec();
        this.itr = new EventIterator(this.getStatement(), resultSet, entitySpec, this.getInboundRefSpecs(), this.getBidirectionalRefSpecs(), new InboundReferenceResultSetIterator(entitySpec.getName()));
    }

    @Override
    final DataStreamingEventIterator<Event> getResults() {
        if (this.itr != null) {
            return this.itr;
        }
        return EMPTY_EVENT_ITR;
    }

    @Override
    DataStreamingEventIterator<UniqueIdPair> getInboundReferenceResults() {
        if (this.itr != null) {
            return this.itr.getReferenceIterator();
        }
        return EMPTY_UNIQUE_ID_PAIR_ITR;
    }

    class EventIterator
    extends PropositionResultSetIterator<Event> {
        private final Logger logger;
        private final DataSourceBackendSourceSystem dsType;
        private final IntervalFactory intervalFactory;
        private final JDBCPositionFormat positionParser;
        private EntitySpec entitySpec;
        private final Date now;

        EventIterator(Statement statement, ResultSet resultSet, EntitySpec entitySpec, Map<String, ReferenceSpec> inboundRefSpecs, Map<String, ReferenceSpec> bidirectionalRefSpecs, InboundReferenceResultSetIterator referenceIterator) throws SQLException {
            super(statement, resultSet, entitySpec, inboundRefSpecs, bidirectionalRefSpecs, EventStreamingResultProcessor.this.getDataSourceBackendId(), referenceIterator);
            this.logger = SQLGenUtil.logger();
            this.dsType = DataSourceBackendSourceSystem.getInstance((String)EventStreamingResultProcessor.this.getDataSourceBackendId());
            this.intervalFactory = new IntervalFactory();
            this.positionParser = entitySpec.getPositionParser();
            this.entitySpec = entitySpec;
            this.now = new Date();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void doProcess(ResultSet resultSet, String[] uniqueIds, ColumnSpec codeSpec, EntitySpec entitySpec, Map<String, ReferenceSpec> bidirectionalRefSpec, int[] columnTypes, String[] propIds, PropertySpec[] propertySpecs, Value[] propertyValues, UniqueIdPair[] refUniqueIds) throws SQLException {
            String kId;
            int i = 1;
            if ((kId = resultSet.getString(i++)) == null) {
                this.logger.warning("A keyId is null. Skipping record.");
                return;
            }
            this.handleKeyId(kId);
            i = AbstractResultProcessor.readUniqueIds(uniqueIds, resultSet, i);
            if (Arrays.contains((Object[])uniqueIds, null)) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.log(Level.WARNING, "Unique ids contain null ({0}). Skipping record.", StringUtils.join((Object[])uniqueIds, (String)", "));
                }
                this.getReferenceIterator().addUniqueIds(kId, null);
                return;
            }
            UniqueId uniqueId = EventStreamingResultProcessor.this.generateUniqueId(entitySpec.getName(), uniqueIds);
            String propId = null;
            if (!EventStreamingResultProcessor.this.isCasePresent()) {
                String code;
                if (codeSpec == null) {
                    assert (propIds.length == 1) : "Don't know which proposition id to assign to";
                    propId = propIds[0];
                } else if ((propId = StreamingMainResultProcessor.sqlCodeToPropositionId(codeSpec, code = resultSet.getString(i++))) == null) {
                    this.getReferenceIterator().addUniqueIds(kId, null);
                    return;
                }
            } else {
                ++i;
            }
            ColumnSpec finishTimeSpec = entitySpec.getFinishTimeSpec();
            Granularity gran = entitySpec.getGranularity();
            Interval interval = null;
            if (finishTimeSpec == null) {
                Long d = null;
                try {
                    d = this.positionParser.toPosition(resultSet, i, columnTypes[i - 1]);
                    ++i;
                }
                catch (SQLException e) {
                    this.logger.log(Level.WARNING, "Could not parse timestamp. Leaving the start time/timestamp unset.", e);
                }
                interval = this.intervalFactory.getInstance(d, gran);
            } else {
                Long start = null;
                try {
                    start = this.positionParser.toPosition(resultSet, i, columnTypes[i - 1]);
                }
                catch (SQLException e) {
                    this.logger.log(Level.WARNING, "Could not parse start time. Leaving the start time/timestamp unset.", e);
                }
                finally {
                    ++i;
                }
                Long finish = null;
                try {
                    finish = this.positionParser.toPosition(resultSet, i, columnTypes[i - 1]);
                }
                catch (SQLException e) {
                    this.logger.log(Level.WARNING, "Could not parse start time. Leaving the finish time unset.", e);
                }
                finally {
                    ++i;
                }
                if (finish != null && start != null && finish.compareTo(start) < 0) {
                    this.logger.log(Level.WARNING, "Finish {0} is before start {1}: Leaving time unset", new Object[]{finish, start});
                    interval = this.intervalFactory.getInstance(null, gran, null, gran);
                } else {
                    interval = this.intervalFactory.getInstance(start, gran, finish, gran);
                }
            }
            i = EventStreamingResultProcessor.this.extractPropertyValues(resultSet, i, propertyValues, columnTypes);
            i = EventStreamingResultProcessor.this.extractReferenceUniqueIdPairs(resultSet, uniqueId, refUniqueIds, i);
            this.getReferenceIterator().addUniqueIds(kId, refUniqueIds);
            if (EventStreamingResultProcessor.this.isCasePresent()) {
                propId = resultSet.getString(i++);
            }
            if (!EventStreamingResultProcessor.this.queryPropIds.contains(propId)) {
                return;
            }
            Event event = new Event(propId, uniqueId);
            event.setSourceSystem((SourceSystem)this.dsType);
            event.setInterval(interval);
            for (int j = 0; j < propertySpecs.length; ++j) {
                PropertySpec propertySpec = propertySpecs[j];
                event.setProperty(propertySpec.getName(), propertyValues[j]);
            }
            event.setDownloadDate(this.now);
            this.handleProposition(event);
            this.logger.log(Level.FINEST, "Created event {0}", event);
        }

        @Override
        void fireResultSetCompleted() {
            this.getReferenceIterator().resultSetComplete();
        }
    }
}

