/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.ProtempaUtil;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.JDBCPositionFormat;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.SQLGenUtil;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.ValueType;

public final class EntitySpec
implements Serializable {
    private static final long serialVersionUID = -1935588032831088001L;
    private static final PropertySpec[] EMPTY_PROPERTY_SPEC_ARRAY = new PropertySpec[0];
    private static final ReferenceSpec[] EMPTY_REFERENCE_SPEC_ARRAY = new ReferenceSpec[0];
    private static final ColumnSpec[] EMPTY_COLUMN_SPEC_ARRAY = new ColumnSpec[0];
    private final String name;
    private final String description;
    private final String[] propositionIds;
    private final boolean unique;
    private final ColumnSpec baseSpec;
    private final ColumnSpec[] uniqueIdSpecs;
    private final ColumnSpec startTimeOrTimestampSpec;
    private final ColumnSpec finishTimeSpec;
    private final PropertySpec[] propertySpecs;
    private final ReferenceSpec[] referenceSpecs;
    private final Map<String, String> codeToPropIdMap;
    private final ColumnSpec codeSpec;
    private final ColumnSpec[] constraintSpecs;
    private final ValueType valueType;
    private final ColumnSpec valueSpec;
    private final Granularity granularity;
    private final JDBCPositionFormat positionParser;
    private final Unit partitionBy;
    private final int[] maxWidths;

    public EntitySpec(String name, String description, String[] propositionIds, boolean unique, ColumnSpec baseSpec, ColumnSpec[] uniqueIdSpecs, ColumnSpec startTimeOrTimestampSpec, ColumnSpec finishTimeSpec, PropertySpec[] propertySpecs, ReferenceSpec[] referenceSpecs, Map<String, String> codeToPropIdMap, ColumnSpec codeSpec, ColumnSpec[] constraintSpecs, ColumnSpec valueSpec, ValueType valueType, Granularity granularity, JDBCPositionFormat positionParser, Unit partitionBy) {
        this(name, description, propositionIds, unique, baseSpec, uniqueIdSpecs, startTimeOrTimestampSpec, finishTimeSpec, propertySpecs, referenceSpecs, codeToPropIdMap, codeSpec, constraintSpecs, valueSpec, valueType, granularity, positionParser, partitionBy, null);
    }

    public EntitySpec(String name, String description, String[] propositionIds, boolean unique, ColumnSpec baseSpec, ColumnSpec[] uniqueIdSpecs, ColumnSpec startTimeOrTimestampSpec, ColumnSpec finishTimeSpec, PropertySpec[] propertySpecs, ReferenceSpec[] referenceSpecs, Map<String, String> codeToPropIdMap, ColumnSpec codeSpec, ColumnSpec[] constraintSpecs, ColumnSpec valueSpec, ValueType valueType, Granularity granularity, JDBCPositionFormat positionParser, Unit partitionBy, int[] maxWidths) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        if (positionParser == null && (startTimeOrTimestampSpec != null || finishTimeSpec != null)) {
            throw new IllegalArgumentException("positionParser cannot be null for entities with a start time and/or finish time");
        }
        if (propositionIds != null) {
            this.propositionIds = (String[])propositionIds.clone();
            ProtempaUtil.internAll((String[])this.propositionIds);
            ProtempaUtil.checkArrayForNullElement((Object[])this.propositionIds, (String)"propositionIds");
            if (this.propositionIds.length == 0) {
                SQLGenUtil.logger().log(Level.WARNING, "No mappings are specified for entity spec {0}", name);
            }
            if (this.propositionIds.length > 1 && codeSpec == null) {
                throw new IllegalArgumentException("if propositionIds has multiple proposition ids, there must be a codeSpec to differentiate between them");
            }
        } else {
            throw new IllegalArgumentException("propositionIds cannot be null");
        }
        if (baseSpec == null) {
            throw new IllegalArgumentException("baseSpec cannot be null");
        }
        this.baseSpec = baseSpec;
        if (description == null) {
            description = "";
        }
        this.description = description;
        this.unique = unique;
        ProtempaUtil.checkArray((Object[])uniqueIdSpecs, (String)"uniqueIdSpecs");
        this.uniqueIdSpecs = uniqueIdSpecs;
        this.startTimeOrTimestampSpec = startTimeOrTimestampSpec;
        this.finishTimeSpec = finishTimeSpec;
        if (propertySpecs != null) {
            this.propertySpecs = (PropertySpec[])propertySpecs.clone();
            ProtempaUtil.checkArrayForNullElement((Object[])this.propertySpecs, (String)"propertySpecs");
        } else {
            this.propertySpecs = EMPTY_PROPERTY_SPEC_ARRAY;
        }
        if (referenceSpecs != null) {
            ProtempaUtil.checkArrayForNullElement((Object[])referenceSpecs, (String)"referenceSpecs");
            EntitySpec.checkReferenceSpecArrayForDuplicates(referenceSpecs);
            for (ReferenceSpec rs : this.referenceSpecs = (ReferenceSpec[])referenceSpecs.clone()) {
                rs.setReferringEntitySpec(this);
            }
        } else {
            this.referenceSpecs = EMPTY_REFERENCE_SPEC_ARRAY;
        }
        this.codeToPropIdMap = codeToPropIdMap != null ? new HashMap<String, String>(codeToPropIdMap) : Collections.emptyMap();
        this.codeSpec = codeSpec;
        if (constraintSpecs != null) {
            this.constraintSpecs = new ColumnSpec[constraintSpecs.length];
            System.arraycopy(constraintSpecs, 0, this.constraintSpecs, 0, constraintSpecs.length);
            ProtempaUtil.checkArrayForNullElement((Object[])this.constraintSpecs, (String)"constraintSpecs");
        } else {
            this.constraintSpecs = EMPTY_COLUMN_SPEC_ARRAY;
        }
        if (valueType != null && valueSpec == null) {
            throw new IllegalArgumentException("valueType must have a corresponding valueSpec");
        }
        if (valueType == null && valueSpec != null) {
            throw new IllegalArgumentException("valueSpec must have a corresponding valueType");
        }
        this.valueType = valueType;
        this.valueSpec = valueSpec;
        this.granularity = granularity;
        this.positionParser = positionParser;
        this.partitionBy = partitionBy;
        if (maxWidths == null) {
            this.maxWidths = null;
        } else {
            if (maxWidths.length != this.uniqueIdSpecs.length) {
                throw new IllegalArgumentException("maxWidths, if not null, must have the same number of values as uniqueIdSpecs");
            }
            this.maxWidths = (int[])maxWidths.clone();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getPropositionIds() {
        return (String[])this.propositionIds.clone();
    }

    public boolean isUnique() {
        return this.unique;
    }

    public ColumnSpec getBaseSpec() {
        return this.baseSpec;
    }

    public ColumnSpec[] getUniqueIdSpecs() {
        return (ColumnSpec[])this.uniqueIdSpecs.clone();
    }

    public ColumnSpec getStartTimeSpec() {
        return this.startTimeOrTimestampSpec;
    }

    public ColumnSpec getFinishTimeSpec() {
        return this.finishTimeSpec;
    }

    public PropertySpec[] getPropertySpecs() {
        return (PropertySpec[])this.propertySpecs.clone();
    }

    public ReferenceSpec[] getReferenceSpecs() {
        return (ReferenceSpec[])this.referenceSpecs.clone();
    }

    public boolean hasReferenceTo(EntitySpec entitySpec) {
        if (entitySpec == null) {
            throw new IllegalArgumentException("entitySpec cannot be null");
        }
        boolean found = false;
        String entitySpecName = entitySpec.name;
        for (ReferenceSpec refSpec : this.referenceSpecs) {
            if (!refSpec.getEntityName().equals(entitySpecName)) continue;
            found = true;
        }
        return found;
    }

    public ReferenceSpec[] referencesTo(EntitySpec entitySpec) {
        if (entitySpec == null) {
            throw new IllegalArgumentException("entitySpec cannot be null");
        }
        ArrayList<ReferenceSpec> result = new ArrayList<ReferenceSpec>();
        String entitySpecName = entitySpec.name;
        for (ReferenceSpec refSpec : this.referenceSpecs) {
            if (!refSpec.getEntityName().equals(entitySpecName)) continue;
            result.add(refSpec);
        }
        return result.toArray(new ReferenceSpec[result.size()]);
    }

    public Map<String, String> getCodeToPropIdMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.codeToPropIdMap);
        return result;
    }

    public ColumnSpec getCodeSpec() {
        return this.codeSpec;
    }

    public ColumnSpec[] getConstraintSpecs() {
        return (ColumnSpec[])this.constraintSpecs.clone();
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public ColumnSpec getValueSpec() {
        return this.valueSpec;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public JDBCPositionFormat getPositionParser() {
        return this.positionParser;
    }

    public Unit getPartitionBy() {
        return this.partitionBy;
    }

    public int[] getMaxWidths() {
        if (this.maxWidths == null) {
            return null;
        }
        return (int[])this.maxWidths.clone();
    }

    public ColumnSpec[] getColumnSpecs() {
        HashSet<ColumnSpec> results = new HashSet<ColumnSpec>();
        this.addTo(results, this.baseSpec);
        this.addTo(results, this.codeSpec);
        this.addTo(results, this.constraintSpecs);
        this.addTo(results, this.finishTimeSpec);
        this.addTo(results, this.startTimeOrTimestampSpec);
        this.addTo(results, this.uniqueIdSpecs);
        this.addTo(results, this.valueSpec);
        for (PropertySpec propertySpec : this.propertySpecs) {
            this.addTo(results, propertySpec.getCodeSpec());
        }
        return results.toArray(new ColumnSpec[results.size()]);
    }

    private void addTo(Set<ColumnSpec> tableSpecs, ColumnSpec ... colSpecs) {
        for (ColumnSpec colSpec : colSpecs) {
            if (colSpec == null) continue;
            for (ColumnSpec cs : colSpec.asList()) {
                tableSpecs.add(cs);
            }
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("description", (Object)this.description).append("propositionIds", (Object[])this.propositionIds).append("unique", this.unique).append("baseSpec", (Object)this.baseSpec).append("uniqueIdSpecs", (Object[])this.uniqueIdSpecs).append("startTimeOrTimestampSpec", (Object)this.startTimeOrTimestampSpec).append("finishTimeSpec", (Object)this.finishTimeSpec).append("propertySpecs", (Object[])this.propertySpecs).append("referenceSpecs", (Object[])this.referenceSpecs).append("codeToPropIdMap", this.codeToPropIdMap).append("codeSpec", (Object)this.codeSpec).append("constraintSpecs", (Object[])this.constraintSpecs).append("valueType", (Object)this.valueType).append("valueSpec", (Object)this.valueSpec).append("granularity", (Object)this.granularity).append("positionParser", (Object)this.positionParser).append("partitionBy", (Object)this.partitionBy).toString();
    }

    private static void checkReferenceSpecArrayForDuplicates(ReferenceSpec[] refSpecs) {
        HashSet<RefSpecUID> duplicates = new HashSet<RefSpecUID>();
        HashSet<RefSpecUID> refNames = new HashSet<RefSpecUID>();
        for (ReferenceSpec refSpec : refSpecs) {
            String entitySpecName;
            String refName = refSpec.getReferenceName();
            RefSpecUID uid = new RefSpecUID(refName, entitySpecName = refSpec.getEntityName());
            if (refNames.add(uid)) continue;
            duplicates.add(uid);
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException("Duplicate reference names " + StringUtils.join(duplicates, (String)", "));
        }
    }

    private static class RefSpecUID {
        String refName;
        String entitySpecName;

        RefSpecUID(String refName, String entitySpecName) {
            this.refName = refName;
            this.entitySpecName = entitySpecName;
        }

        public int hashCode() {
            int result = 17;
            int c = this.refName.hashCode();
            result = 31 * result + c;
            c = this.entitySpecName.hashCode();
            result = 31 * result + c;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RefSpecUID other = (RefSpecUID)obj;
            if (!Objects.equals(this.refName, other.refName)) {
                return false;
            }
            return Objects.equals(this.entitySpecName, other.entitySpecName);
        }

        public String toString() {
            return this.refName + " to entity " + this.entitySpecName;
        }
    }
}

