/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.config.Data;
import edu.emory.cci.aiw.i2b2etl.dest.config.DataSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.Settings;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.MetadataUtil;
import edu.emory.cci.aiw.i2b2etl.dest.table.DimensionFactory;
import edu.emory.cci.aiw.i2b2etl.dest.table.InvalidPatientRecordException;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientDimensionHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.PatientMappingHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import edu.emory.cci.aiw.i2b2etl.dest.table.VitalStatusCode;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.AbsoluteTimeGranularity;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;
import org.protempa.proposition.value.AbsoluteTimeUnit;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.Value;

public class PatientDimensionFactory
extends DimensionFactory {
    private final Metadata metadata;
    private final PatientDimension patientDimension;
    private final PatientDimensionHandler patientDimensionHandler;
    private final PatientMappingHandler patientMappingHandler;
    private final Settings settings;

    public PatientDimensionFactory(Metadata metadata, Settings settings, Data obxSection, ConnectionSpec dataConnectionSpec) throws SQLException {
        super(obxSection);
        this.settings = settings;
        this.metadata = metadata;
        this.patientDimension = new PatientDimension();
        this.patientDimensionHandler = new PatientDimensionHandler(dataConnectionSpec);
        this.patientMappingHandler = new PatientMappingHandler(dataConnectionSpec);
    }

    public PatientDimension getInstance(String keyId, Proposition encounterProp, Map<UniqueId, Proposition> references) throws InvalidPatientRecordException, SQLException {
        String obxSectionStr = this.settings.getPatientDimensionMRN();
        DataSpec dataSpec = this.getData().get(obxSectionStr);
        List uids = encounterProp.getReferences(dataSpec.getReferenceName());
        int size = uids.size();
        Logger logger = TableUtil.logger();
        this.patientDimension.setEncryptedPatientId(keyId);
        this.patientDimension.setEncryptedPatientIdSource(this.metadata.getSourceSystemCode());
        if (size > 0) {
            Proposition prop;
            if (size > 1) {
                logger.log(Level.WARNING, "Multiple propositions with MRN property found for {0}, using only the first one", encounterProp);
            }
            if ((prop = references.get(uids.get(0))) == null) {
                throw new InvalidPatientRecordException("Encounter's " + dataSpec.getReferenceName() + " reference points to a non-existant proposition");
            }
            Value val = prop.getProperty(dataSpec.getPropertyName());
            if (val != null) {
                Date deathDate;
                Date birthdate;
                Value zipCode = this.getField(this.settings.getPatientDimensionZipCode(), encounterProp, references);
                Value maritalStatus = this.getField(this.settings.getPatientDimensionMaritalStatus(), encounterProp, references);
                Value race = this.getField(this.settings.getPatientDimensionRace(), encounterProp, references);
                Value birthdateVal = this.getField(this.settings.getPatientDimensionBirthdate(), encounterProp, references);
                Value deathDateVal = this.getField(this.settings.getPatientDimensionDeathDate(), encounterProp, references);
                Value vitalStatus = this.getField(this.settings.getPatientDimensionVital(), encounterProp, references);
                Value gender = this.getField(this.settings.getPatientDimensionGender(), encounterProp, references);
                Value language = this.getField(this.settings.getPatientDimensionLanguage(), encounterProp, references);
                Value religion = this.getField(this.settings.getPatientDimensionReligion(), encounterProp, references);
                if (birthdateVal != null) {
                    try {
                        birthdate = ((DateValue)birthdateVal).getDate();
                    }
                    catch (ClassCastException cce) {
                        birthdate = null;
                        logger.log(Level.WARNING, "Birthdate property value not a DateValue");
                    }
                } else {
                    birthdate = null;
                }
                if (deathDateVal != null) {
                    try {
                        deathDate = ((DateValue)deathDateVal).getDate();
                    }
                    catch (ClassCastException cce) {
                        deathDate = null;
                        logger.log(Level.WARNING, "DeathDate property value not a DateValue");
                    }
                } else {
                    deathDate = null;
                }
                Long ageInYears = this.computeAgeInYears(birthdate);
                this.patientDimension.setZip(zipCode != null ? zipCode.getFormatted() : null);
                this.patientDimension.setAgeInYears(ageInYears);
                this.patientDimension.setGender(gender != null ? gender.getFormatted() : null);
                this.patientDimension.setLanguage(language != null ? language.getFormatted() : null);
                this.patientDimension.setReligion(religion != null ? religion.getFormatted() : null);
                this.patientDimension.setBirthDate(TableUtil.setDateAttribute(birthdate));
                this.patientDimension.setDeathDate(TableUtil.setDateAttribute(deathDate));
                this.patientDimension.setMaritalStatus(maritalStatus != null ? maritalStatus.getFormatted() : null);
                this.patientDimension.setRace(race != null ? race.getFormatted() : null);
                this.patientDimension.setSourceSystem(MetadataUtil.toSourceSystemCode(prop.getSourceSystem().getStringRepresentation()));
                if (vitalStatus instanceof NominalValue) {
                    this.patientDimension.setVital(VitalStatusCode.fromCode(vitalStatus.getFormatted()).getCode());
                } else if (vitalStatus instanceof BooleanValue) {
                    this.patientDimension.setVital(VitalStatusCode.getInstance(((BooleanValue)vitalStatus).booleanValue()).getCode());
                } else {
                    this.patientDimension.setVital(VitalStatusCode.getInstance(null).getCode());
                }
                Date updateDate = prop.getUpdateDate();
                this.patientDimension.setUpdated(TableUtil.setTimestampAttribute(updateDate != null ? updateDate : prop.getCreateDate()));
                this.patientDimension.setDownloaded(TableUtil.setTimestampAttribute(prop.getDownloadDate()));
            }
        }
        this.patientDimensionHandler.insert(this.patientDimension);
        this.patientMappingHandler.insert(this.patientDimension);
        return this.patientDimension;
    }

    public void close() throws SQLException {
        boolean firstClosed = false;
        try {
            this.patientDimensionHandler.close();
            firstClosed = true;
            this.patientMappingHandler.close();
        }
        catch (SQLException ex) {
            if (!firstClosed) {
                try {
                    this.patientMappingHandler.close();
                }
                catch (SQLException ignore) {
                    ex.addSuppressed(ignore);
                }
            }
            throw ex;
        }
    }

    private Long computeAgeInYears(Date birthdate) {
        Long ageInYears = birthdate != null ? Long.valueOf(AbsoluteTimeGranularity.YEAR.distance(AbsoluteTimeGranularityUtil.asPosition((Date)birthdate).longValue(), AbsoluteTimeGranularityUtil.asPosition((Date)new Date()).longValue(), (Granularity)AbsoluteTimeGranularity.YEAR, (Unit)AbsoluteTimeUnit.YEAR)) : null;
        return ageInYears;
    }
}

