/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.ConnectionSpecQueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryConstructor;
import edu.emory.cci.aiw.i2b2etl.ksb.QueryExecutor;
import edu.emory.cci.aiw.i2b2etl.ksb.TableAccessReader;
import java.sql.Connection;
import java.sql.SQLException;
import org.arp.javautil.sql.ConnectionSpec;
import org.arp.javautil.sql.DatabaseAPI;
import org.arp.javautil.sql.InvalidConnectionSpecArguments;
import org.protempa.KnowledgeSourceReadException;

class QuerySupport {
    private static final String DEFAULT_EUREKA_ID_COLUMN = "EK_UNIQUE_ID";
    private DatabaseAPI databaseApi = DatabaseAPI.DRIVERMANAGER;
    private String databaseId;
    private String username;
    private String password;
    private ConnectionSpec connectionSpecInstance;
    private String excludeTableName;
    private TableAccessReader ontTableReader = new TableAccessReader(null);
    private String eurekaIdColumn = "EK_UNIQUE_ID";

    QuerySupport() {
    }

    String getEurekaIdColumn() {
        return this.eurekaIdColumn;
    }

    void setEurekaIdColumn(String eurekaIdColumn) {
        this.eurekaIdColumn = eurekaIdColumn;
    }

    DatabaseAPI getDatabaseApi() {
        return this.databaseApi;
    }

    void setDatabaseApi(DatabaseAPI databaseApi) {
        this.databaseApi = databaseApi;
        this.connectionSpecInstance = null;
    }

    String getDatabaseId() {
        return this.databaseId;
    }

    void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
        this.connectionSpecInstance = null;
    }

    String getUsername() {
        return this.username;
    }

    void setUsername(String username) {
        this.username = username;
        this.connectionSpecInstance = null;
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = password;
        this.connectionSpecInstance = null;
    }

    String getExcludeTableName() {
        return this.excludeTableName;
    }

    void setExcludeTableName(String excludeTableName) {
        this.excludeTableName = excludeTableName;
        this.ontTableReader = new TableAccessReader(excludeTableName);
    }

    Connection getConnection() throws InvalidConnectionSpecArguments, SQLException {
        return this.databaseApi.newConnectionSpecInstance(this.databaseId, this.username, this.password, false).getOrCreate();
    }

    ConnectionSpecQueryExecutor getQueryExecutorInstance(QueryConstructor queryConstructor) throws KnowledgeSourceReadException {
        try {
            return new ConnectionSpecQueryExecutor(this.databaseApi, this.databaseId, this.username, this.password, this.connectionSpecInstance, queryConstructor, this.ontTableReader);
        }
        catch (SQLException | InvalidConnectionSpecArguments ex) {
            throw new KnowledgeSourceReadException(ex);
        }
    }

    QueryExecutor getQueryExecutorInstance(Connection connection, QueryConstructor queryConstructor) throws KnowledgeSourceReadException {
        if (connection != null) {
            return new QueryExecutor(connection, queryConstructor, this.ontTableReader);
        }
        return this.getQueryExecutorInstance(queryConstructor);
    }
}

