/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.datastore;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.datastore.BdbStoreFactory;
import org.arp.javautil.datastore.DataStoreUtil;

public class BdbPersistentStoreFactory<E, V>
extends BdbStoreFactory<E, V> {
    private static final String CLASS_CATALOG = "java_class_catalog";

    public BdbPersistentStoreFactory(String pathname) {
        super(pathname, false);
    }

    @Override
    protected StoredClassCatalog createClassCatalog(Environment env) throws IllegalArgumentException, DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTemporary(false);
        dbConfig.setAllowCreate(true);
        Database catalogDb = env.openDatabase(null, CLASS_CATALOG, dbConfig);
        return new StoredClassCatalog(catalogDb);
    }

    @Override
    protected EnvironmentConfig createEnvConfig() {
        Logger logger = DataStoreUtil.logger();
        EnvironmentConfig envConf = new EnvironmentConfig();
        envConf.setAllowCreate(true);
        envConf.setTransactional(true);
        logger.log(Level.FINE, "Calculating cache size");
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        long max = memoryUsage.getMax();
        long used = memoryUsage.getUsed();
        long available = max - used;
        long cacheSize = Math.round((double)available / 6.0);
        envConf.setCacheSize(cacheSize);
        logger.log(Level.FINE, "Cache size set to {0}", cacheSize);
        return envConf;
    }

    @Override
    protected DatabaseConfig createDatabaseConfig() {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTemporary(false);
        return dbConfig;
    }
}

