/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.table;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptDimension;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptDimensionHandler;
import edu.emory.cci.aiw.i2b2etl.dest.table.ConceptHierarchyLoader;
import edu.emory.cci.aiw.i2b2etl.dest.table.TableUtil;
import java.sql.SQLException;

public final class ConceptDimensionLoader
extends ConceptHierarchyLoader {
    private final ConceptDimensionHandler handler;
    private final ConceptDimension conceptDimension;

    public ConceptDimensionLoader(ConceptDimensionHandler handler) {
        this.handler = handler;
        this.conceptDimension = new ConceptDimension();
    }

    @Override
    protected void loadConcept(Concept concept) throws SQLException {
        if (concept.isInUse() && !concept.isModifier()) {
            for (String path : concept.getHierarchyPaths()) {
                this.conceptDimension.setPath(path);
                this.conceptDimension.setConceptCode(concept.getConceptCode());
                this.conceptDimension.setDisplayName(concept.getDisplayName());
                this.conceptDimension.setSourceSystemCode(concept.getSourceSystemCode());
                this.conceptDimension.setDownloaded(TableUtil.setTimestampAttribute(concept.getDownloaded()));
                this.conceptDimension.setUpdated(TableUtil.setTimestampAttribute(concept.getUpdated()));
                this.handler.insert(this.conceptDimension);
            }
        }
    }
}

