/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.protempa.backend.dsb.relationaldb.AbstractResultProcessor;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.JDBCValueFormat;
import org.protempa.backend.dsb.relationaldb.PropertySpec;
import org.protempa.backend.dsb.relationaldb.ResultCache;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueType;

abstract class MainResultProcessor<P extends Proposition>
extends AbstractResultProcessor {
    private ResultCache<P> results;
    private ColumnSpec[] lastColumnSpecs;
    private PropertySpec[] propertySpecs;

    protected MainResultProcessor(ResultCache<P> results, EntitySpec entitySpec, String dataSourceBackendId) {
        super(entitySpec, dataSourceBackendId);
        assert (results != null) : "resultCache cannot be null";
        this.results = results;
        this.propertySpecs = this.getEntitySpec().getPropertySpecs();
        this.lastColumnSpecs = new ColumnSpec[this.propertySpecs.length];
    }

    final ResultCache<P> getResults() {
        return this.results;
    }

    protected static String sqlCodeToPropositionId(ColumnSpec codeSpec, String code) throws SQLException {
        return codeSpec.getTarget(code);
    }

    protected int extractPropertyValues(ResultSet resultSet, int i, Value[] propertyValues, int[] colTypes) throws SQLException {
        for (int j = 0; j < this.propertySpecs.length; ++j) {
            Value value;
            PropertySpec propertySpec = this.propertySpecs[j];
            ValueType valueType = propertySpec.getValueType();
            JDBCValueFormat valueFormat = propertySpec.getJDBCValueFormat();
            if (valueFormat != null) {
                value = valueFormat.toValue(resultSet, i, colTypes[i - 1]);
            } else {
                String valAsString;
                String propId;
                ColumnSpec columnSpec = this.lastColumnSpecs[j];
                if (columnSpec == null) {
                    ColumnSpec cs = propertySpec.getCodeSpec();
                    List<ColumnSpec> codeSpecL = cs.asList();
                    this.lastColumnSpecs[j] = columnSpec = codeSpecL.get(codeSpecL.size() - 1);
                }
                if ((propId = columnSpec.getTarget(valAsString = resultSet.getString(i))) != null) {
                    valAsString = propId;
                }
                value = valueType.parse(valAsString);
            }
            ++i;
            propertyValues[j] = value;
        }
        return i;
    }
}

