/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.dsb.relationaldb.oracle;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.backend.dsb.relationaldb.ColumnSpec;
import org.protempa.backend.dsb.relationaldb.ColumnSpecInfo;
import org.protempa.backend.dsb.relationaldb.ColumnSpecInfoFactory;
import org.protempa.backend.dsb.relationaldb.EntitySpec;
import org.protempa.backend.dsb.relationaldb.FromClause;
import org.protempa.backend.dsb.relationaldb.IntColumnSpecWrapper;
import org.protempa.backend.dsb.relationaldb.ReferenceSpec;
import org.protempa.backend.dsb.relationaldb.SQLGenResultProcessor;
import org.protempa.backend.dsb.relationaldb.SQLOrderBy;
import org.protempa.backend.dsb.relationaldb.SelectClause;
import org.protempa.backend.dsb.relationaldb.StagedColumnSpec;
import org.protempa.backend.dsb.relationaldb.StagingSelectClause;
import org.protempa.backend.dsb.relationaldb.StagingSpec;
import org.protempa.backend.dsb.relationaldb.TableAliaser;
import org.protempa.backend.dsb.relationaldb.WhereClause;
import org.protempa.backend.dsb.relationaldb.oracle.Ojdbc6OracleSelectStatement;
import org.protempa.backend.dsb.relationaldb.oracle.Ojdbc6OracleStagingFromClause;

final class Ojdbc6OracleStagingSelectStatement
extends Ojdbc6OracleSelectStatement {
    private final StagingSpec stagingSpec;
    private final boolean streamingMode;
    private final boolean wrapKeyId;
    private static final StagingSpec[] EMPTY_SSPEC_ARR = new StagingSpec[0];

    Ojdbc6OracleStagingSelectStatement(EntitySpec entitySpec, ReferenceSpec referenceSpec, List<EntitySpec> entitySpecs, Set<Filter> filters, Set<String> propIds, Set<String> keyIds, SQLOrderBy order, SQLGenResultProcessor resultProcessor, StagingSpec stagingSpec, boolean streamingMode, boolean wrapKeyId) {
        super(entitySpec, referenceSpec, entitySpecs, new TreeMap<String, ReferenceSpec>(), filters, propIds, keyIds, order, resultProcessor, EMPTY_SSPEC_ARR, streamingMode, wrapKeyId);
        this.stagingSpec = stagingSpec;
        this.streamingMode = streamingMode;
        this.wrapKeyId = wrapKeyId;
    }

    @Override
    public String generateStatement() {
        ColumnSpecInfo info = new ColumnSpecInfoFactory().newInstance(this.getPropIds(), this.getEntitySpec(), this.getEntitySpecs(), this.getInboundReferenceSpecs(), this.getFilters(), this.getReferenceSpec(), this.streamingMode);
        ArrayList<IntColumnSpecWrapper> plusStagedSpecs = new ArrayList<IntColumnSpecWrapper>(info.getColumnSpecs());
        for (StagedColumnSpec spec : this.stagingSpec.getStagedColumns()) {
            IntColumnSpecWrapper icsw = new IntColumnSpecWrapper(spec.toColumnSpec());
            icsw.setIsSameAs(this.getEntitySpec().getBaseSpec().getLastSpec());
            plusStagedSpecs.add(icsw);
        }
        TableAliaser referenceIndices = new TableAliaser(plusStagedSpecs, "a");
        SelectClause select = this.getSelectClause(info, referenceIndices, this.getEntitySpec(), this.wrapKeyId);
        FromClause from = this.getFromClause(this.toColumnSpecs(info.getColumnSpecs()), referenceIndices, EMPTY_SSPEC_ARR);
        WhereClause where = this.getWhereClause(this.getPropIds(), info, this.getEntitySpecs(), this.getFilters(), referenceIndices, this.getKeyIds(), this.getOrder(), this.getResultProcessor(), select, EMPTY_SSPEC_ARR);
        StringBuilder result = new StringBuilder(select.generateClause()).append(" ").append(from.generateClause()).append(" ").append(where.generateClause());
        return result.toString();
    }

    @Override
    protected SelectClause getSelectClause(ColumnSpecInfo info, TableAliaser referenceIndices, EntitySpec entitySpec, boolean wrapKeyId) {
        return new StagingSelectClause(this.stagingSpec, entitySpec, referenceIndices);
    }

    @Override
    protected FromClause getFromClause(List<ColumnSpec> columnSpecs, TableAliaser referenceIndices, StagingSpec[] stagedTables) {
        return new Ojdbc6OracleStagingFromClause(this.getEntitySpec(), this.getInboundReferenceSpecs(), columnSpecs, referenceIndices, stagedTables);
    }

    @Override
    protected WhereClause getWhereClause(Set<String> propIds, ColumnSpecInfo info, List<EntitySpec> entitySpecs, Set<Filter> filters, TableAliaser referenceIndices, Set<String> keyIds, SQLOrderBy order, SQLGenResultProcessor resultProcessor, SelectClause selectClause, StagingSpec[] stagedTables) {
        return super.getWhereClause(propIds, info, entitySpecs, filters, referenceIndices, keyIds, order, resultProcessor, selectClause, stagedTables);
    }
}

