/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mvel.AbstractParser;
import org.mvel.Accessor;
import org.mvel.CompileException;
import org.mvel.OptimizationFailure;
import org.mvel.PropertyAccessException;
import org.mvel.PropertyAccessor;
import org.mvel.UnresolveablePropertyException;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizationNotSupported;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ArrayTools;
import org.mvel.util.PropertyTools;

public class ASTNode
implements Cloneable,
Serializable {
    public static final int LITERAL = 1;
    public static final int DEEP_PROPERTY = 2;
    public static final int OPERATOR = 4;
    public static final int IDENTIFIER = 8;
    public static final int COMPILE_IMMEDIATE = 16;
    public static final int NUMERIC = 32;
    public static final int NEGATION = 64;
    public static final int INVERT = 256;
    public static final int FOLD = 512;
    public static final int METHOD = 1024;
    public static final int ASSIGN = 2048;
    public static final int LOOKAHEAD = 4096;
    public static final int COLLECTION = 8192;
    public static final int THISREF = 16384;
    public static final int INLINE_COLLECTION = 32768;
    public static final int STR_LITERAL = 65536;
    public static final int BLOCK_IF = 262144;
    public static final int BLOCK_FOREACH = 524288;
    public static final int BLOCK_WITH = 0x100000;
    public static final int BLOCK_WHILE = 0x200000;
    public static final int INTEGER32 = 0x800000;
    protected int firstUnion;
    protected int endOfName;
    protected int fields = 0;
    protected Class egressType;
    protected char[] name;
    protected String nameCache;
    protected Object literal;
    protected transient Accessor accessor;
    protected int cursorPosition;
    public ASTNode nextASTNode;
    protected boolean discard;
    protected int intRegister;

    public ASTNode() {
    }

    public ASTNode(char[] expr, int start, int end, int fields) {
        this.fields = fields;
        this.cursorPosition = start;
        char[] name = new char[end - this.cursorPosition];
        int i = 0;
        while (i < name.length) {
            name[i] = expr[i + start];
            ++i;
        }
        this.setName(name);
    }

    public ASTNode(char[] expr, int fields) {
        this.fields = fields;
        this.name = expr;
    }

    public ASTNode(int fields, Object literalValue) {
        this.fields = fields;
        this.literal = literalValue;
    }

    protected String getAbsoluteRootElement() {
        if ((this.fields & 0x2002) != 0) {
            return new String(this.name, 0, this.getAbsoluteFirstPart());
        }
        return new String(this.name);
    }

    public Class getEgressType() {
        return this.egressType;
    }

    public void setEgressType(Class egressType) {
        this.egressType = egressType;
    }

    protected String getAbsoluteRemainder() {
        return (this.fields & 0x2000) != 0 ? new String(this.name, this.endOfName, this.name.length - this.endOfName) : ((this.fields & 2) != 0 ? new String(this.name, this.firstUnion + 1, this.name.length - this.firstUnion - 1) : null);
    }

    public char[] getNameAsArray() {
        return this.name;
    }

    private int getAbsoluteFirstPart() {
        if ((this.fields & 0x2000) != 0) {
            if (this.firstUnion < 0 || this.endOfName < this.firstUnion) {
                return this.endOfName;
            }
            return this.firstUnion;
        }
        if ((this.fields & 2) != 0) {
            return this.firstUnion;
        }
        return -1;
    }

    public String getAbsoluteName() {
        if ((this.fields & 0x2002) != 0) {
            return new String(this.name, 0, this.getAbsoluteFirstPart());
        }
        return this.getName();
    }

    public String getName() {
        if (this.nameCache != null) {
            return this.nameCache;
        }
        if (this.name != null) {
            this.nameCache = new String(this.name);
            return this.nameCache;
        }
        return "";
    }

    public Object getLiteralValue() {
        return this.literal;
    }

    public void setLiteralValue(Object literal) {
        this.literal = literal;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return this.valRet(this.accessor.getValue(ctx, thisValue, factory));
        }
        catch (NullPointerException e) {
            AccessorOptimizer optimizer;
            Object retVal = null;
            if ((this.fields & 0x200) != 0) {
                optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
                this.accessor = optimizer.optimizeFold(this.name, ctx, thisValue, factory);
                retVal = this.accessor.getValue(ctx, thisValue, factory);
            } else {
                try {
                    optimizer = OptimizerFactory.getThreadAccessorOptimizer();
                    this.accessor = optimizer.optimizeAccessor(this.name, ctx, thisValue, factory, true);
                }
                catch (OptimizationNotSupported ne) {
                    optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
                    this.accessor = optimizer.optimizeAccessor(this.name, ctx, thisValue, factory, true);
                }
            }
            if (this.accessor == null) {
                throw new OptimizationFailure("failed optimization", e);
            }
            if (retVal == null) {
                retVal = optimizer.getResultOptPass();
            }
            if (this.egressType == null) {
                this.egressType = optimizer.getEgressType();
            }
            return this.valRet(retVal);
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if ((this.fields & 1) != 0) {
            if ((this.fields & 0x4000) != 0) {
                return thisValue;
            }
            return this.literal;
        }
        if ((this.fields & 0x200) != 0 && this.accessor == null) {
            AccessorOptimizer optimizer = OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE);
            this.accessor = optimizer.optimizeFold(this.name, ctx, thisValue, factory);
            return optimizer.getResultOptPass();
        }
        if ((this.fields & 2) != 0) {
            String s = this.getAbsoluteRootElement();
            if (AbstractParser.LITERALS.containsKey(s)) {
                Class<?> clazz;
                this.literal = AbstractParser.LITERALS.get(s);
                try {
                    clazz = Class.forName("org.mvel.util.ThisLiteral");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (this.literal == clazz) {
                    this.literal = thisValue;
                }
                return this.valRet(PropertyAccessor.get(this.getAbsoluteRemainder(), this.literal, factory, thisValue));
            }
            if (factory != null && factory.isResolveable(s)) {
                return this.valRet(PropertyAccessor.get(this.name, ctx, factory, thisValue));
            }
            if (ctx != null) {
                try {
                    return this.valRet(PropertyAccessor.get(this.name, ctx, factory, thisValue));
                }
                catch (PropertyAccessException e) {
                    this.literal = this.tryStaticAccess(ctx, factory);
                    if (this.literal == null) {
                        throw e;
                    }
                    this.fields |= 1;
                    this.literal = this.valRet(this.literal);
                    return this.literal;
                }
            }
        } else {
            String s;
            if (factory != null && factory.isResolveable(s = this.getAbsoluteName())) {
                if (this.isCollection()) {
                    return this.valRet(PropertyAccessor.get(new String(this.name, this.endOfName, this.name.length - this.endOfName), factory.getVariableResolver(s).getValue(), factory, thisValue));
                }
                return this.valRet(factory.getVariableResolver(s).getValue());
            }
            if (ctx != null) {
                try {
                    return this.valRet(PropertyAccessor.get(this.name, ctx, factory, thisValue));
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw new UnresolveablePropertyException(this, (Throwable)e);
                }
            }
            if (this.isOperator()) {
                throw new CompileException("incomplete statement: " + new String(this.name));
            }
            int mBegin = ArrayTools.findFirst('(', this.name);
            if (mBegin != -1 && factory.isResolveable(s = new String(this.name, 0, mBegin))) {
                Method m = (Method)factory.getVariableResolver(s).getValue();
                return this.valRet(PropertyAccessor.get(String.valueOf(m.getName()) + new String(this.name, mBegin, this.name.length - mBegin), m.getDeclaringClass(), factory, thisValue));
            }
            throw new CompileException("can not resolve identifier: '" + new String(this.name) + "'");
        }
        this.literal = this.tryStaticAccess(ctx, factory);
        if (this.literal == null) {
            throw new UnresolveablePropertyException(this);
        }
        return this.valRet(this.literal);
    }

    protected Object valRet(Object value) {
        if ((this.fields & 0x40) != 0) {
            try {
                return new Boolean((Boolean)value == false);
            }
            catch (Exception e) {
                throw new CompileException("illegal negation of non-boolean value");
            }
        }
        if ((this.fields & 0x100) != 0) {
            try {
                return new Integer(~((Integer)value).intValue());
            }
            catch (Exception e) {
                throw new CompileException("bitwise (~) operator can only be applied to integers");
            }
        }
        return value;
    }

    protected Object tryStaticAccess(Object thisRef, VariableResolverFactory factory) {
        try {
            boolean meth = false;
            int depth = 0;
            int last = this.name.length;
            int i = last - 1;
            while (i > 0) {
                switch (this.name[i]) {
                    case '.': {
                        if (depth == 0 && !meth) {
                            try {
                                return PropertyAccessor.get(new String(this.name, last, this.name.length - last), Thread.currentThread().getContextClassLoader().loadClass(new String(this.name, 0, last)), factory, thisRef);
                            }
                            catch (ClassNotFoundException e) {
                                return PropertyAccessor.get(new String(this.name, i + 1, this.name.length - i - 1), Thread.currentThread().getContextClassLoader().loadClass(new String(this.name, 0, i)), factory, thisRef);
                            }
                        }
                        meth = false;
                        last = i;
                        break;
                    }
                    case ')': {
                        ++depth;
                        break;
                    }
                    case '(': {
                        if (--depth != 0) break;
                        meth = true;
                    }
                }
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void setName(char[] name) {
        this.name = name;
        this.literal = new String(name);
        if ((this.fields & 1) == 0) {
            if (AbstractParser.LITERALS.containsKey(this.literal)) {
                Class<?> clazz;
                this.fields |= 9;
                this.literal = this.valRet(AbstractParser.LITERALS.get(this.literal));
                try {
                    clazz = Class.forName("org.mvel.util.ThisLiteral");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (this.literal == clazz) {
                    this.fields |= 0x4000;
                }
                if (this.literal != null) {
                    this.egressType = this.literal.getClass();
                }
            } else {
                if (AbstractParser.OPERATORS.containsKey(this.literal)) {
                    this.fields |= 4;
                    this.literal = AbstractParser.OPERATORS.get(this.literal);
                    this.egressType = this.literal.getClass();
                    return;
                }
                if (PropertyTools.isNumber(name)) {
                    this.literal = PropertyTools.handleNumericConversion(name);
                    this.egressType = this.literal.getClass();
                    if (((this.fields |= 0x29) & 0x100) != 0) {
                        try {
                            this.literal = new Integer(~((Integer)this.literal).intValue());
                        }
                        catch (ClassCastException e) {
                            throw new CompileException("bitwise (~) operator can only be applied to integers");
                        }
                    }
                    if (this.literal instanceof Integer) {
                        this.intRegister = (Integer)this.literal;
                        this.fields |= 0x800000;
                    }
                    return;
                }
                if ((this.fields & 0x8000) != 0) {
                    return;
                }
                this.firstUnion = ArrayTools.findFirst('.', name);
                this.fields = this.firstUnion > 0 ? ((this.fields & 0x400) != 0 ? (this.firstUnion < ArrayTools.findFirst('(', name) ? (this.fields |= 0xA) : (this.fields |= 8)) : (this.fields |= 0xA)) : (this.fields |= 8);
            }
        }
        if ((this.endOfName = ArrayTools.findFirst('[', name)) > 0) {
            this.fields |= 0x2000;
        }
    }

    public void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public boolean isIdentifier() {
        return (this.fields & 8) != 0;
    }

    public boolean isLiteral() {
        return (this.fields & 1) != 0;
    }

    public boolean isThisVal() {
        return (this.fields & 0x4000) != 0;
    }

    public boolean isOperator() {
        return (this.fields & 4) != 0;
    }

    public boolean isOperator(Integer operator) {
        return (this.fields & 4) != 0 && operator.equals(this.literal);
    }

    public Integer getOperator() {
        return (Integer)this.literal;
    }

    protected boolean isCollection() {
        return (this.fields & 0x2000) != 0;
    }

    public boolean isAssignment() {
        return (this.fields & 0x800) != 0;
    }

    public boolean isDeepProperty() {
        return (this.fields & 2) != 0;
    }

    public void setAsLiteral() {
        this.fields |= 1;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    public void discard() {
        this.discard = true;
    }

    public boolean isDebuggingSymbol() {
        return this.fields == -1;
    }

    public int getIntRegister() {
        return this.intRegister;
    }

    public void setIntRegister(int intRegister) {
        this.intRegister = intRegister;
    }

    public int getFields() {
        return this.fields;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public String toString() {
        return this.name != null ? new String(this.name) : String.valueOf(this.literal);
    }
}

